/*
 * Copyright (c) 2010 ICM Uniwersytet Warszawski All rights reserved. See LICENCE file for licensing
 * information.
 * 
 * Author: T. Rękawek <newton@mat.uni.torun.pl>
 */

package de.fzj.unicore.uas.impl.dsms;

import java.util.Calendar;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemTypeEnumeration;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import pl.edu.icm.dsms.catalogue.CatalogueClient;

import de.fzj.unicore.uas.impl.dsms.operation.helper.CatalogueClientUtils;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

/**
 * DSMS resource properties.
 * 
 * @author newton
 * 
 */
public class DSMSFileSystemRP extends ResourceProperty<Object> {
	private static final long serialVersionUID = 1L;

	public static final String DESCRIPTION = "DSMS";

	private static final int UPDATE_INTERVAL = 5;

	private final FileSystemDocument[] xdoc;

	private final EndpointReferenceType catalogueEpr;

	private long cachedFreeSpace;

	private Calendar lastUpdated;

	public DSMSFileSystemRP(ResourceImpl parent, String name, EndpointReferenceType catalogueEpr) {
		super(parent);
		this.catalogueEpr = catalogueEpr;
		FileSystemDocument fs = FileSystemDocument.Factory.newInstance();
		fs.addNewFileSystem().setName(name);
		fs.getFileSystem().setFileSystemType(FileSystemTypeEnumeration.NORMAL);
		xdoc = new FileSystemDocument[] { fs };
	}

	@Override
	public ResourceProperty<Object> update() throws Exception {
		FileSystemDocument fs = xdoc[0];
		fs.getFileSystem().setDescription(DESCRIPTION);

		long freeSpace = getFreeSpace();
		if (freeSpace != 0) {
			RangeValueType range = RangeValueType.Factory.newInstance();
			range.addNewExact().setDoubleValue(freeSpace);
			fs.getFileSystem().setDiskSpace(range);
		}
		return this;
	}

	@Override
	public FileSystemDocument[] getXml() {
		return xdoc;
	}

	private long getFreeSpace() throws Exception {
		Calendar time = Calendar.getInstance();
		time.add(Calendar.MINUTE, -UPDATE_INTERVAL);
		if (lastUpdated == null || time.after(lastUpdated)) {
			CatalogueClient client = CatalogueClientUtils.getCatalogueClient(this.parentWSResource
					.getKernel().getClientConfiguration(), catalogueEpr);
			cachedFreeSpace = client.getResourcePropertiesDocument().getCatalogueProperties()
					.getSharedStorageProperties().getFreeSpace();
			lastUpdated = Calendar.getInstance();
		}
		return cachedFreeSpace;
	}
}