package de.fzj.unicore.uas.impl.dsms;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

import pl.edu.icm.dsms.catalogue.model.Lda;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

public class DSMSCatalogueCache {

	private final Cache cache;

	public DSMSCatalogueCache() {
		net.sf.ehcache.config.Configuration cmCfg = new net.sf.ehcache.config.Configuration();
		CacheConfiguration def = new CacheConfiguration();
		cmCfg.setUpdateCheck(false);
		cmCfg.addDefaultCache(def);
		// EHCache doesn't accept 2 CMs with same (even null) disk path even when nothing
		// is stored on disk ;-(
		DiskStoreConfiguration dsCfg = new DiskStoreConfiguration();
		dsCfg.setPath(System.getProperty("java.io.tmpdir") + File.separator + "catalougeCache"
				+ new Random().nextLong());
		cmCfg.addDiskStore(dsCfg);
		CacheManager cacheMan = new CacheManager(cmCfg);
		cache = new Cache("catalogue", 100, MemoryStoreEvictionPolicy.LFU, false, null, false, 300, 300,
				false, 60, null);
		cacheMan.addCache(cache);
	}

	public void put(String path, String dSmsId, Lda lda) {
		Element element = new Element(getKey(path, dSmsId), lda);
		cache.put(element);
	}

	public Lda get(String path, String dSmsId) {
		Element el = cache.get(getKey(path, dSmsId));
		if (el != null && el.getValue() instanceof Lda) {
			return (Lda) el.getValue();
		} else {
			return null;
		}
	}

	public void remove(String path, String dSmsId) {
		cache.remove(getKey(path, dSmsId));
	}

	public void removeDir(String path, String dSmsId) {
		for (Object key : cache.getKeys()) {
			@SuppressWarnings("unchecked")
			List<String> list = (List<String>) key;
			if (dSmsId.equals(list.get(1)) && list.get(0).startsWith(path)) {
				cache.remove(key);
			}
		}
	}

	private Object getKey(String path, String dSmsId) {
		return Arrays.asList(path, dSmsId);
	}
}
