package de.fzj.unicore.uas.impl.dsms;

import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.AbstractStartupTask;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.exceptions.ResourceNotCreatedException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;

public class CreateDSMSOnStartup extends AbstractStartupTask {
	private static final Logger logger = LogUtil.getLogger(LogUtil.UNICORE, CreateDSMSOnStartup.class);

	public static final String DSMS_RES_ID_PREFIX = "dsms_";

	@Override
	public void run() {
		Kernel kernel = getKernel();
		DSMSGeneralProperties config = kernel.getAttribute(DSMSGeneralProperties.class);
		if (config == null) {
			config = new DSMSGeneralProperties(kernel.getContainerProperties().getRawProperties());
			kernel.addConfigurationHandler(DSMSGeneralProperties.class, config);
		}

		Home smsHome = kernel.getHome(UAS.SMS);
		if (smsHome == null) {
			logger.info("No dSMS configured for this site.");
			return;
		}

		Collection<StorageDescription> storages = config.getDSMSStorages();

		for (StorageDescription storage : storages) {
			createIfNotExists(smsHome, storage);
		}
	}

	private void createIfNotExists(Home smsHome, StorageDescription desc) {
		String resId = DSMS_RES_ID_PREFIX + desc.getName().toLowerCase();
		logger.info("Creating DSMS " + resId + ": " + desc);
		try {
			try {
				if (smsHome.get(resId) != null) {
					logger.error(resId + " already exists, skipping");
					return;
				}
			} catch (ResourceUnknownException e) {
			}
			doCreateSMS(smsHome, resId, desc);
		} catch (Exception e) {
			logger.error("Could not add " + resId, e);
		}
	}

	private void doCreateSMS(Home smsHome, String resId, StorageDescription conf)
			throws ResourceNotCreatedException {
		Map<String, Object> imap = new HashMap<String, Object>();
		imap.put(WSResourceImpl.INIT_UNIQUE_ID, resId);
		imap.put(DSMSImpl.DSMS_CONFIG, conf);

		Calendar c = new GregorianCalendar();
		c.add(Calendar.MONTH, 72);
		imap.put(WSResourceImpl.INIT_INITIAL_TERMINATION_TIME, c);
		imap.put(UASWSResourceImpl.INITPARAM_PUBLISH_TO_REGISTRY, true);
		imap.put(SMSBaseImpl.INIT_STORAGE_DESCRIPTION, conf);
		smsHome.createWSRFServiceInstance(imap);
		logger.info("Added dSMS resource " + resId + ".");
	}
}
