package de.fzj.unicore.uas.xnjs;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.net.URI;
import java.util.Properties;

import javax.security.auth.x500.X500Principal;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.io.FileUtils;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.junit.Test;
import org.unigrids.services.atomic.types.PermissionsDocument;

import de.fzj.unicore.uas.TestSecConfigs;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.XNJS;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.io.Permissions;
import eu.unicore.security.Client;
import eu.unicore.security.SecurityTokens;

public class TestVarious {

	@Test
	public void test0()throws Exception{
		URI uri=new URI("bft:http://somehost:1234?res=mystorage#foo.txt");
		assertEquals("http://somehost:1234?res=mystorage", uri.getSchemeSpecificPart());
	}
	
	@Test
	public void testPermissionConverter(){
		PermissionsDocument pd=PermissionsDocument.Factory.newInstance();
		pd.addNewPermissions();
		Permissions p=XNJSFacade.getXNJSPermissions(pd.getPermissions());
		assertEquals("r",String.valueOf(p));
		pd.getPermissions().setExecutable(true);
		pd.getPermissions().setWritable(true);
		p=XNJSFacade.getXNJSPermissions(pd.getPermissions());
		assertEquals("rwx",String.valueOf(p));
	}
	
	@Test
	public void testSecurityHelpers()throws Exception{
		FileUtils.deleteQuietly(new File("target", "data"));
		Properties p = TestSecConfigs.getKernelProperties();
		Kernel k = new Kernel(p);
		
		XNJS xnjs=new XNJS("src/test/resources/xnjs.xml");
		xnjs.start();
		Configuration config=xnjs.getConfig();
		config.registerComponent(k);
		U6HttpConnectionFactory f=new U6HttpConnectionFactory(config);
		HttpClient httpClient=f.getConnection("https://foo", makeClient());
		assertNotNull(httpClient);	
		
		xnjs.stop();
	}
	
	@Test
	public void testCertToUspaceProcessor()throws Exception{
		FileUtils.deleteQuietly(new File("target", "data"));
		Kernel k=new Kernel(TestSecConfigs.getKernelProperties());
		XNJS xnjs=new XNJS("src/test/resources/xnjs.xml");
		xnjs.start();
		Configuration config=xnjs.getConfig();
		config.registerComponent(k);
		JobDefinitionDocument job=JobDefinitionDocument.Factory.newInstance();
		job.addNewJobDefinition().addNewJobDescription().addNewApplication().setApplicationName("Date");
		Action a=config.makeAction(job);
		Client c=makeClient();
		String text="This is not a real proxy";
		c.getExtraAttributes().put("Proxy", text);
		a.setClient(c);
		config.getExecutionContextMgr().getContext(a);
		ProxyCertToUspaceProcessor p=new ProxyCertToUspaceProcessor(config);
		p.setAction(a);
		p.handleCreated();
		File f=new File(a.getExecutionContext().getWorkingDirectory(),".proxy");
		assertTrue(f.exists());
		assertEquals(text,FileUtils.readFileToString(f));
		xnjs.stop();
	}
	
	private Client makeClient(){
		Client client=new Client();
		SecurityTokens t=new SecurityTokens();
		t.setUserName(new X500Principal("CN=test"));
		client.setAuthenticatedClient(t);
		return client;
	}
}
