package de.fzj.unicore.uas.xnjs;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

import de.fzj.unicore.wsrflite.utils.Utilities;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.jsdl.Incarnation;
import de.fzj.unicore.xnjs.jsdl.IncarnationDataBase;
import de.fzj.unicore.xnjs.jsdl.JSDLResourceSet;
import de.fzj.unicore.xnjs.legacy.TSIUtils;
import de.fzj.unicore.xnjs.resources.ResourceSet;
import de.fzj.unicore.xnjs.tsi.IReservation;
import de.fzj.unicore.xnjs.tsi.ReservationStatus;
import de.fzj.unicore.xnjs.tsi.ReservationStatus.Status;
import eu.unicore.security.Client;

public class MockReservation implements IReservation {

	private static Map<String, ReservationStatus> reservations=new HashMap<String, ReservationStatus>();

	public static String lastTSICommand;
	
	private final Configuration configuration;
	
	public MockReservation(Configuration configuration){
		this.configuration=configuration;
	}
	
	public void cancelReservation(String resID, Client arg1)
	throws ExecutionException {
		reservations.remove(resID);
	}

	public String makeReservation(XmlObject resources, Calendar startTime, Client client)
	throws ExecutionException {
		try{
			ResourcesType rt_original=ResourcesType.Factory.parse(resources.newInputStream());
			//merge resource request with IDB defaults...
			Incarnation gr=configuration.getGrounder();
			IncarnationDataBase idb=configuration.getIDB();
			ResourceSet incarnated=gr.incarnateResources(new JSDLResourceSet(rt_original), client);
			String tsiCmd=TSIUtils.makeMakeReservationCommand(incarnated,startTime,idb,client);
			lastTSICommand=tsiCmd;
			String resID=Utilities.newUniqueID();
			ReservationStatus rs=new ReservationStatus();
			rs.setStartTime(startTime);
			rs.setStatus(Status.WAITING);
			rs.setDescription("OK");
			reservations.put(resID, rs);
			return resID;
		}catch(Exception e){
			throw new ExecutionException(e);
		}
	}

	public static int count;
	
	public ReservationStatus queryReservation(String resID,Client arg2)
	throws ExecutionException {
		count++;
		//fake slow execution of the query command
		try{
			Thread.sleep(3000);
		}catch(InterruptedException ie){}
		return reservations.get(resID);
	}

	public static void clearCallCounter(){
		count=0;
	}
	
	public static boolean hasReservation(String id){
		return reservations.containsKey(id);
	}

}
