package de.fzj.unicore.uas.testsuite;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.junit.Test;
import org.unigrids.x2006.x04.services.tss.SubmitDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.Base;
import de.fzj.unicore.uas.TargetSystemFactory;
import de.fzj.unicore.uas.client.TSFClient;
import de.fzj.unicore.uas.client.TSSClient;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.sg.Registry;
import eu.unicore.bugsreporter.annotation.FunctionalTest;
import eu.unicore.util.httpclient.ClientProperties;

public class TestTSSReinit extends Base {
	String url;
	EndpointReferenceType epr;

	@FunctionalTest(id="TSSReinit", 
			description="Tests TargetSystemService behaviour when re-created by a user")
	@Test
	public void testRecreate()throws Exception{
		url=kernel.getContainerProperties().getValue(ContainerProperties.WSRF_BASEURL);
		epr=EndpointReferenceType.Factory.newInstance();
		epr.addNewAddress().setStringValue(url+"/"+Registry.REGISTRY_SERVICE+"?res=default_registry");
		ClientProperties securityProps = kernel.getClientConfiguration();
		
		RegistryClient reg=new RegistryClient(epr, securityProps);
		//find a TargetSystemFactory
		List<EndpointReferenceType> tsfs=reg.listServices(TargetSystemFactory.TSF_PORT);
		EndpointReferenceType tsfepr=findFirstAccessibleService(tsfs);
		TSFClient tsf=new TSFClient(tsfepr,securityProps);
		tsf.setUpdateInterval(-1);
		//clean up all TSSs to avoid dependencies on other tests...
		for(EndpointReferenceType tEpr: tsf.getTargetSystems()){
			new TSSClient(tEpr,securityProps).destroy();
		}
		assertTrue(tsf.getTargetSystems().size()==0);
		TSSClient tss = tsf.createTSS();
		assertTrue(tsf.getTargetSystems().size()==1);
		
		int numJobs=3;
		
		for(int i=0;i<numJobs;i++){
			runJob(tss);
		}
		Thread.sleep(5000);
		tss.setUpdateInterval(-1);
		long nj=tss.getJobs().size();
		assertEquals(numJobs,nj);
		tss.destroy();
		
		tss=tsf.createTSS();
		//need to wait a bit...
		int c=0;
		String lastStatus=null;
		while(c<10){
			String s=tss.getServiceStatus();
			if(!s.equals(lastStatus)){
				lastStatus=s;
				System.out.println("TSS Status is: "+s);	
			}
			Thread.sleep(1000);
			c++;
			if("READY".equals(s))break;
		}
		
		assertEquals(numJobs, tss.getJobs().size());
	}

	
	private void runJob(TSSClient tss)throws Exception{
		SubmitDocument sd=SubmitDocument.Factory.newInstance();
		sd.addNewSubmit().setAutoStartWhenReady(true);
		JobDefinitionType jobDefinition=JobDefinitionType.Factory.newInstance();
		jobDefinition.addNewJobDescription().addNewApplication().setApplicationName("Date");
		sd.getSubmit().setJobDefinition(jobDefinition);
		tss.submit(sd);
	}


}
