package de.fzj.unicore.uas.testsuite;

import static org.junit.Assert.*;

import java.io.ByteArrayOutputStream;
import java.util.List;

import org.junit.Test;
import org.unigrids.services.atomic.types.GridFileType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.Base;
import de.fzj.unicore.uas.StorageFactory;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.StorageFactoryClient;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.sg.Registry;
import eu.unicore.bugsreporter.annotation.FunctionalTest;

public class TestStorageFactory extends Base {
	String url;
	EndpointReferenceType epr;

	@Test
	@FunctionalTest(id="StorageFactoryTest", description="Tests StorageFactory service")
	public void testStorageFactory()throws Exception{
		url=kernel.getContainerProperties().getValue(ContainerProperties.WSRF_BASEURL);
		epr=EndpointReferenceType.Factory.newInstance();
		epr.addNewAddress().setStringValue(url+"/"+Registry.REGISTRY_SERVICE+"?res=default_registry");
		RegistryClient reg=new RegistryClient(epr,kernel.getClientConfiguration());
		//find a StorageFactory
		List<EndpointReferenceType> tsfs=reg.listServices(StorageFactory.SMF_PORT);
		assertTrue(tsfs!=null && tsfs.size()>0);
		EndpointReferenceType tsfepr=findFirstAccessibleService(tsfs);
		assertTrue(tsfepr!=null);
		System.out.println("Using StorageFactory at "+tsfepr.getAddress().getStringValue());

		StorageFactoryClient smf=new StorageFactoryClient(tsfepr,kernel.getClientConfiguration());
		System.out.println(smf.getResourcePropertyDocument());
		checkBasic(smf);
		checkCreateWithCustomName(smf);
		checkCreateWithCustomType(smf);
	}

	private void checkBasic(StorageFactoryClient smf)throws Exception{
		int n=smf.getAccessibleStorages().size();
		assertTrue(0==n);

		StorageClient sms=smf.createSMS();
		smf.setUpdateInterval(-1);

		List<EndpointReferenceType>st=smf.getStorages();
		assertTrue(st!=null && st.size()>0);

		n=st.size();
		assertTrue(1==n);

		checkNewStorage(sms);

		//now destroy the sms and check if the factory properties are OK
		sms.destroy();
		n=smf.getAccessibleStorages().size();
		assertTrue(0==n);
	}

	private void checkCreateWithCustomName(StorageFactoryClient smf)throws Exception{
		String name="MyNewStorage";
		StorageClient sms=smf.createSMS(null, name, null);
		String finalName = sms.getStorageName();
		assertEquals(name, finalName);
	}

	private void checkCreateWithCustomType(StorageFactoryClient smf)throws Exception{
		String name="MyNewStorage";
		String type="TEST";

		StorageClient sms=smf.createSMS(type, name, null);
		assertTrue(name.equals(sms.getStorageName()));
	}

	private void checkNewStorage(StorageClient sms)throws Exception{
		//check if the created SMS is OK...
		GridFileType[] files=sms.listDirectory("/");
		//should be empty
		assertTrue(files.length==0);
		//upload some data
		sms.getImport("test").append("some testdata".getBytes());
		//and download it again
		ByteArrayOutputStream os=new ByteArrayOutputStream();
		sms.getExport("test").readAllData(os);
		assertTrue("some testdata".equals(os.toString()));
		files=sms.listDirectory("/");
		assertTrue(1==files.length);
	}

}
