package de.fzj.unicore.uas.testsuite;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.services.atomic.types.MetadataType;
import org.unigrids.services.atomic.types.StatusType;
import org.unigrids.x2006.x04.services.metadata.ExtractionStatisticsDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.client.MetadataClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.TaskClient;
import de.fzj.unicore.uas.util.MockMetadataManager;
import eu.unicore.bugsreporter.annotation.FunctionalTest;

/**
 * runs some tests on the metadata support
 * 
 * @author schuller
 */
public class TestMetadata extends AbstractJobRun{

	String url;
	EndpointReferenceType tssepr;

	JobDefinitionDocument jobDescription;

	@FunctionalTest(id="MetadataTest", description="Tests basic metadata support.")
	@Override
	public void testRunJob()throws Exception{
		initClients();
		jobDescription=getJob1();
		JobClient job=submitJob(tss);
		StorageClient sms=job.getUspaceClient();
		System.out.println(sms.getResourcePropertiesDocument());

		//check for metadata support
		assertTrue(sms.supportsMetadata());

		//stage in a file
		String in = "this is a test";
		ByteArrayInputStream bis=new ByteArrayInputStream(in.getBytes());
		String md5=MockMetadataManager.computeMD5(bis);

		stageIn(job,"foo", in.getBytes());

		//get metadata client
		MetadataClient mc=sms.getMetadataClient();
		assertTrue(mc!=null);

		//fill some metadata and see we can retrieve them
		Map<String,String>metadata=new HashMap<String,String>();
		metadata.put("ham","spam");
		metadata.put("test","123");
		mc.createMetadata("/foo", metadata);

		//check md is attached to listProperties() result
		GridFileType file=sms.listProperties("foo");
		assertTrue(file!=null);
		MetadataType meta=file.getMetadata();
		assertTrue(meta!=null);
		System.out.println(file);
		assertTrue(md5.equals(meta.getContentMD5()));

		//get
		Map<String,String>map=mc.getMetadata("/foo");
		assertTrue(map.get("ham").equals("spam"));

		//update
		map.put("newkey", "newvalue");
		mc.updateMetadata("/foo", map);
		map=mc.getMetadata("/foo");
		assertTrue("newvalue".equals(map.get("newkey")));

		//delete
		mc.deleteMetadata("/foo");
		map=mc.getMetadata("/foo");
		assertTrue(0==map.size());

		//create
		map.put("test","test-value");
		mc.createMetadata("/foo", map);
		map=mc.getMetadata("/foo");
		assertTrue(0<map.size());
		assertTrue("test-value".equals(map.get("test")));
		
		//search
		Collection<String>results=mc.search("foo", false);
		assertEquals(1,results.size());
		assertTrue(results.contains("foo"));
		
		//extraction
		TaskClient tc=mc.startMetadataExtraction("/", 4321);
		while( StatusType.SUCCESSFUL != tc.getStatus() && StatusType.FAILED != tc.getStatus() ){
			Thread.sleep(2000);
		}
		System.out.println("Extraction task : "+tc.getStatusMessage());
		ExtractionStatisticsDocument es=ExtractionStatisticsDocument.Factory.parse(tc.getResult().newInputStream());
		int docs=es.getExtractionStatistics().getDocumentsProcessed().intValue();
		assertEquals(4321, docs);
	}

	@Override
	protected JobDefinitionDocument getJob() {
		return jobDescription;
	}

	private JobDefinitionDocument getJob1() {
		JobDefinitionDocument jdd=JobDefinitionDocument.Factory.newInstance();
		ApplicationType app=jdd.addNewJobDefinition().addNewJobDescription().addNewApplication();
		app.setApplicationName("Date");
		return jdd;
	}

}
