package de.fzj.unicore.uas.testsuite;

import java.io.ByteArrayOutputStream;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.FileNameType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationType;
import org.junit.Ignore;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.services.atomic.types.ProtocolType;
import org.unigrids.x2006.x04.services.sms.ImportFileDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.client.RByteIOClient;
import de.fzj.unicore.uas.client.StorageClient;

/**
 * creates a fifo in a uspace and does some tests with it
 * 
 * @author schuller
 */
@Ignore
public class TestFIFO extends AbstractJobRun{
	
	String url;
	EndpointReferenceType tssepr;
	EndpointReferenceType fifoEpr;

	JobDefinitionDocument jobDescription;

	@Override
	public void testRunJob()throws Exception{
		initClients();
		jobDescription=getJob1();
		runJob(tss);
		//check stdout
		ByteArrayOutputStream bos=new ByteArrayOutputStream();
		job.getUspaceClient().getExport("stdout").readAllData(bos);
		String stdout=bos.toString();
		System.out.println("Output: "+stdout);
	}



	//make a fifo file before starting the job
	@Override
	protected void beforeStart(JobClient jms) throws Exception {
		super.beforeStart(jms);

		StorageClient sms=job.getUspaceClient();

		ImportFileDocument in=ImportFileDocument.Factory.newInstance();
		in.addNewImportFile().setIsPipe(true);
		in.getImportFile().setDestination("fifo");
		in.getImportFile().setProtocol(ProtocolType.RBYTEIO);
		fifoEpr=sms.ImportFile(in).getImportFileResponse().getImportEPR();
		
		GridFileType[] ls=sms.listDirectory("/");
		for(GridFileType f: ls)System.out.println(f);

	}
	//make a fifo file before starting the job
	@Override
	protected void afterStart(JobClient jms) throws Exception {
		super.afterStart(jms);
		StorageClient sms=job.getUspaceClient();
		//write some data to the fifo
		RByteIOClient c=new RByteIOClient(fifoEpr, sms.getSecurityConfiguration());
		c.write("/bin/echo Hello World \n".getBytes());
		Thread.sleep(1000);
		c.destroy();
	}

	@Override
	protected JobDefinitionDocument getJob() {
		return jobDescription;
	}

	//job with redirected input
	private JobDefinitionDocument getJob1() {
		JobDefinitionDocument jdd=JobDefinitionDocument.Factory.newInstance();
		ApplicationType app=jdd.addNewJobDefinition().addNewJobDescription().addNewApplication();
		POSIXApplicationDocument pad=POSIXApplicationDocument.Factory.newInstance();
		POSIXApplicationType pa=pad.addNewPOSIXApplication();
		pa.addNewExecutable().setStringValue("/bin/bash");
		FileNameType in=FileNameType.Factory.newInstance();
		in.setStringValue("fifo");
		pa.setInput(in);
		app.set(pad);
		System.out.println(jdd);
		return jdd;
	}


}
