package de.fzj.unicore.uas.testsuite;

import static org.junit.Assert.assertTrue;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.client.JobClient;
import eu.unicore.bugsreporter.annotation.FunctionalTest;

public class RunDate extends AbstractJobRun{

	EndpointReferenceType tssepr;
	
	@Override
	@FunctionalTest(id="RunDateTest", description="Runs a 'date' job.")
	public void testRunJob()throws Exception{
		super.testRunJob();
	}

	@Override
	protected JobDefinitionDocument getJob() {
		JobDefinitionDocument jdd=JobDefinitionDocument.Factory.newInstance();
		ApplicationType app=jdd.addNewJobDefinition().addNewJobDescription().addNewApplication();
		app.setApplicationName("Date");
		app.setApplicationVersion("1.0");
		return jdd;
	}
	
	@Override
	protected void beforeStart(JobClient job)throws Exception{
		System.out.println("Job submitted at: "+job.getSubmissionTime());
		job.getUspaceClient().getImport("test.txt").write("import test".getBytes());
		job.getUspaceClient().getImport("folder/test.txt").write("import test in subfolder".getBytes());
	}
	
	@Override
	protected void onFinish(JobClient job) throws Exception{
		String out=getStdout(job);
		assertTrue(out!=null && out.length()>0);
		if(doDestroy())job.destroy();
	}

	protected boolean doDestroy(){
		return true;
	}

}
