package de.fzj.unicore.uas.testsuite;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.client.JobClient;
import eu.unicore.bugsreporter.annotation.FunctionalTest;

/**
 * stages in a file from a plain https location
 * (makes sense only in secure mode)
 *
 * @author schuller
 */
public class RunCatWithHttpsStagein extends AbstractJobRun {

	String url;
	EndpointReferenceType tssepr;

	@Override
	protected void beforeStart(JobClient jms) throws Exception {
	}

	@Override
	protected void onFinish(JobClient jms) throws Exception {
		String out=getStdout(jms);
		System.out.println(out);
		if(!out.contains("Registry"))throw new Exception("Error occured.");
	}

	@FunctionalTest(id="RunCatTestHttps", 
			description="Runs a 'cat' job including a https stage-in")
	@Override
	public void testRunJob()throws Exception{
		super.testRunJob();
	}
	
	@Override
	protected JobDefinitionDocument getJob() {
		JobDefinitionDocument jdd=JobDefinitionDocument.Factory.newInstance();
		ApplicationType app=jdd.addNewJobDefinition().addNewJobDescription().addNewApplication();
		app.setApplicationName("Cat");
		app.setApplicationVersion("1.0");
		DataStagingType dst=jdd.getJobDefinition().getJobDescription().addNewDataStaging();
		dst.addNewSource().setURI("https://localhost:65321/services/Registry?wsdl");
		dst.setFileName("/infile");
		return jdd;
	}
	
}
