package de.fzj.unicore.uas.testsuite;
import java.io.ByteArrayInputStream;
import java.util.Random;

import junit.framework.Assert;

import org.junit.Test;
import org.unigrids.services.atomic.types.ProtocolType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.Base;
import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.StorageFactoryClient;
import de.fzj.unicore.uas.client.TransferControllerClient;
import de.fzj.unicore.wsrflite.ContainerProperties;
import eu.unicore.bugsreporter.annotation.FunctionalTest;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;

/**
 * tests reliable / chunked file download
 * 
 * @author schuller
 */
public class RFTTest extends Base{

	StorageClient sourceStorage;

	@Test
	@FunctionalTest(id="RFTTest", description="Tests the RFT file download")
	public void testRFTDownload()throws Exception{
		UASProperties cfg = kernel.getAttribute(UASProperties.class);
		cfg.setProperty(UASProperties.SMS_TRANSFER_FORCEREMOTE, "true");
		String smfUrl=kernel.getContainerProperties().getValue(ContainerProperties.WSRF_BASEURL)
				+"/StorageFactory?res=default_storage_factory";
		EndpointReferenceType smfAddress=EndpointReferenceType.Factory.newInstance();
		smfAddress.addNewAddress().setStringValue(smfUrl);
		StorageFactoryClient smf=new StorageFactoryClient(smfAddress, getSecurityProperties());
		StorageClient sms=smf.createSMS();

		sourceStorage=smf.createSMS();
		long size=createTestFile("test");
		
		TransferControllerClient tcc=sms.fetchFile("BFT:"+sourceStorage.getUrl()+"#/test", "file", null, true);
		
		while(!tcc.isComplete() && !tcc.hasFailed()){
			Thread.sleep(2000);
		}
		//check target
		Assert.assertTrue(size>0);
		Assert.assertEquals(size, sms.listProperties("file").getSize());
		tcc.setUpdateInterval(-1);
		System.out.println(tcc.getResourcePropertiesDocument());
		
	}

	//create a test file on the default sms
	protected long createTestFile(String file) throws Exception {
		FileTransferClient importClient=sourceStorage.getImport(file, true, null, ProtocolType.BFT);
		int size=128000;
		int loops=100;
		byte[] data=new byte[size];
		Random r=new Random();
		long total=size*loops;
		System.out.println("Importing "+total/(1024*1024)+ " MBytes to "+file);
		for (int i = 0; i < loops; i++) {
			r.nextBytes(data);
			importClient.writeAllData(new ByteArrayInputStream(data));
		}
		long fileSize=sourceStorage.listProperties(file).getSize();
		System.out.println("Remote file size : "+fileSize);
		return fileSize;
	}

	/**
	 * return security settings for making a client call
	 */
	protected IClientConfiguration getSecurityProperties(){
		ClientProperties sp=kernel.getClientConfiguration().clone();
		return sp;
	}
}
