package de.fzj.unicore.uas.testsuite;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Random;

import javax.xml.namespace.QName;

import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.junit.Ignore;
import org.junit.Test;
import org.unigrids.services.atomic.types.ProtocolType;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.client.RByteIOClient;
import de.fzj.unicore.uas.client.SByteIOClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.fts.byteio.StreamableByteIO;
import de.fzj.unicore.uas.fts.byteio.StreamableByteIOImpl;
import de.fzj.unicore.wsrflite.utils.StopWatch;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import eu.unicore.bugsreporter.annotation.FunctionalTest;
import eu.unicore.bugsreporter.annotation.RegressionTest;

/**
 * runs byteio tests on a newly created USspace<br/>
 * This was done for the "ByteIO interop fiesta" <date>
 * 
 * @author schuller
 * @author Shahbaz Memon
 * @author Shiraz Memon
 */
public class ByteIOTest extends AbstractJobRun{

	String url;

	String sampleStr = "010203040506070809101112131415161718192021222324252627282930";

	StorageClient sms;

	@FunctionalTest(id="ByteIOTest", description="Tests the OGSA ByteIO support")
	@Override
	public void testRunJob()throws Exception{
		initClients();
		JobClient job=submitJob(tss);
		sms=job.getUspaceClient();
		//tests...
		import_and_check();
		import_and_check_2();
		read_with_stride();
		read_with_stride_2();
		overwrite();
		overwrite_with_stride();

		//sbyteio
		import_and_verify_2();
		partial_overwrite();

		//testEmpty

	}

	private void import_and_check()throws Exception{
		sms.getImport("testfile").write(sampleStr.getBytes());
		sms.getImport("testfile").append("++++++".getBytes());
		RByteIOClient rb=sms.getExport("testfile");
		String s=String.valueOf(rb.getResourcePropertiesDocument());
		assertTrue(s.contains("TransferMechanism"));
		assertTrue(s.contains("Readable"));
		String res=new String(rb.read(0,1,66,0));
		System.out.println(res);
		assertTrue((sampleStr+"++++++").equals(res));
	}

	private void import_and_check_2()throws Exception{
		RByteIOClient c=sms.getImport("testfile");
		c.write(sampleStr.getBytes());
		System.out.println(c.getResourcePropertyDocument());
		String res=new String(sms.getExport("testfile").read(0,1,60,0));
		assertTrue(sampleStr.equals(res));

	}

	private void read_with_stride()throws Exception{
		String res=new String(sms.getExport("testfile").read(0,2,12,18));
		String verify="010203040506" + "101112131415";
		assertTrue(verify.equals(res));
	}

	private void read_with_stride_2()throws Exception{
		String res=new String(sms.getExport("testfile").read(2,5,2,4));
		String verify="0204060810";
		assertTrue(verify.equals(res));
		SByteIOClient c=sms.getReadStream("testfile");
		c.seekRead(0,3);
		assertTrue(c.getResourcePropertyDocument().toString().contains("3"));
		Map<QName, XmlObject[]> multipr=c.getMultipleResourceProperties(StreamableByteIO.RPReadable,StreamableByteIO.RPWriteable,StreamableByteIO.RPPosition,StreamableByteIO.RPSize);
		for(QName key: multipr.keySet()){
			System.out.println(key);
		}
	}

	//overwrite 
	private void overwrite()throws Exception{
		String data="++++++";
		sms.getImport("testfile").write(data.getBytes(),0,1,6,0);
		String res=new String(sms.getExport("testfile").read(0,1,60,0));
		String verify="++++++040506070809101112131415161718192021222324252627282930";
		assertTrue(verify.equals(res));
	}

	private void overwrite_with_stride()throws Exception{
		//first rewrite the file
		sms.getImport("testfile").write(sampleStr.getBytes());
		String data="++++++";
		sms.getImport("testfile").write(data.getBytes(),0,2,3,6);
		String res=new String(sms.getExport("testfile").read(0,1,60,0));
		String verify="+++203+++506070809101112131415161718192021222324252627282930";
		assertTrue(verify.equals(res));
	}

	private void import_and_verify_2()throws Exception{
		sms.getImport("testfile_2").write(sampleStr.getBytes());
		String res=new String(sms.getExport("testfile_2").read(0,1,60,0));
		assertTrue(sampleStr.equals(res));
	}

	private void partial_overwrite()throws Exception{
		String data="++++++";
		sms.getWriteStream("testfile_2").seekWrite(data.getBytes(),6,StreamableByteIO.SBYTIO_ORIGIN_BEGINNING);
		String res=new String(sms.getExport("testfile_2").read(0,1,60,0));
		String verify="010203++++++070809101112131415161718192021222324252627282930";
		assertTrue(verify.equals(res));
	}

	@FunctionalTest(id="ByteIOMTOMTest", description="Tests the OGSA ByteIO MTOM support")
	@Test 
	@Ignore //until MTOM support is finished
	public void testMTOM()throws Exception{
		initClients();
		JobClient job=submitJob(tss);
		job.waitUntilReady(5000);
		job.start();
		job.waitUntilDone(5000);
		sms=job.getUspaceClient();
		RByteIOClient rb=sms.getExport("/stdout");
		assertTrue(rb.supportsMTOM());
		byte[]data=rb.read(0, 1, 1000, 0);
		assertNotNull(data);
		System.out.println(new String(data));
		
		int size=1024*1024;
		int loops=50;
		//more data
		File testData=File.createTempFile("u6test", "test");
		testData.deleteOnExit();
		writeTestData(testData, size, loops);
		FileTransferClient i1=sms.getImport("/big", ProtocolType.BFT);
		i1.writeAllData(new FileInputStream(testData));
		
		StopWatch sw=new StopWatch();
		sw.start("Start BFT export of "+size*loops/(1024*1024)+ " MBytes");
		FileTransferClient i2=sms.getExport("/big", ProtocolType.BFT);
		i2.readAllData(new NullOutputStream());
		long time=sw.getCurrentTotal();
		System.out.println("End of BFT data export, time="+time/1000+ " sec");
		System.out.println("Rate="+(size*loops)/time+ " kB/sec.");
		
		sw=new StopWatch();
		sw.start("Start MTOM export of "+size*loops/(1024*1024)+ " MBytes");
		//now read using mtom
		rb=(RByteIOClient)sms.getExport("/big", ProtocolType.RBYTEIO);
		System.out.println("File transfer URL: "+rb.getUrl());
		rb.readAllData(new NullOutputStream());
		time=sw.getCurrentTotal();
		System.out.println("End of MTOM data export, time="+time/1000+ " sec");
		System.out.println("Rate="+(size*loops)/time+ " kB/sec.");
	}
	
	@RegressionTest(
			description="Tests that the I/O streams are properly cleaned up",
			url="https://sourceforge.net/tracker/?func=detail&aid=3567664&group_id=102081&atid=633902")
	@Test
	public void testCleanUpSBYTEIO()throws Exception{
		initClients();
		JobClient job=submitJob(tss);
		job.waitUntilReady(5000);
		job.start();
		job.waitUntilDone(5000);
		sms=job.getUspaceClient();
		SByteIOClient sb=(SByteIOClient)sms.getExport("/stdout",ProtocolType.SBYTEIO);
		sb.readAllData(new NullOutputStream());
		String uid=WSUtilities.extractResourceID(sb.getEPR());
		assertTrue(StreamableByteIOImpl.streamExists(uid+"_in"));
		sb.destroy();
		assertFalse(StreamableByteIOImpl.streamExists(uid+"_in"));
	}

	private void writeTestData(File file, int size, int loops)throws IOException{
		byte[] data=new byte[size];
		Random r=new Random();
		FileOutputStream fos=new FileOutputStream(file);
		for (int i = 0; i < loops; i++) {
			r.nextBytes(data);
			IOUtils.copy(new ByteArrayInputStream(data), fos);
		}
		fos.close();
	}
	
	protected JobDefinitionDocument getJob() {
		JobDefinitionDocument jdd=JobDefinitionDocument.Factory.newInstance();
		jdd.addNewJobDefinition().setId("Date");
		jdd.getJobDefinition().addNewJobDescription().addNewApplication().setApplicationName("Date");
		return jdd;
	}
	
}
