package de.fzj.unicore.uas.security;

import java.io.ByteArrayOutputStream;

import javax.xml.namespace.QName;

import org.codehaus.xfire.service.Service;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocument;

import de.fzj.unicore.uas.TestSecConfigs;
import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.security.testservices.ExampleService;
import de.fzj.unicore.uas.security.testservices.IExample;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.xfire.WSRFClientFactory;
import de.fzj.unicore.wsrflite.xfire.XFireKernel;
import de.fzj.unicore.wsrflite.xfire.XFireServiceFactory;
import eu.unicore.security.SecurityTokens;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.IClientConfiguration;

public class TestProxyHandlers {

	private Kernel kernel;
	
	@Before
	public void setUp()throws Exception{
		UAS uas=new UAS("src/test/resources/secure/uas.config.simple");
		uas.startSynchronous();
		kernel=uas.getKernel();
		addServices();
	}

	@After
	public void tearDown()throws Exception{
		kernel.shutdown();
	}


	protected void addServices()throws Exception{
		String serviceName="testProxyHandlers";
		XFireServiceFactory.createAndDeployService(kernel,serviceName,IExample.class, ExampleService.class, false);
		Service s=XFireKernel.get(kernel).getService(serviceName);
		s.addInHandler(new ProxyCertInHandler(kernel));
	}

	@Test
	public void test()throws Exception{
		doTestOutHandler();
		doTestInHandler();
	}

	private void doTestOutHandler()throws Exception{
		// establish security
		IClientConfiguration sec = TestSecConfigs.getClientSecurityCfg(true);
		ProxyCertOutHandler p=new ProxyCertOutHandler();
		p.configure(sec);
		Element ph=p.getProxyHeader();
		ByteArrayOutputStream bos=new ByteArrayOutputStream();
		new XMLOutputter(Format.getPrettyFormat()).output(ph,bos);
		String header = bos.toString();
		Assert.assertTrue(header, header.contains("PRIVATE KEY"));
	}

	
	private void doTestInHandler()throws Exception{
		DefaultClientConfiguration sec = TestSecConfigs.getClientSecurityCfg(true);
		sec.setOutHandlerClassNames(new String[] {ProxyCertOutHandler.class.getName()});
		
		IExample c=new WSRFClientFactory(sec).createPlainWSProxy(IExample.class, getBaseurl()+"/testProxyHandlers");
		GetResourcePropertyDocument in=GetResourcePropertyDocument.Factory.newInstance();
		in.setGetResourceProperty(new QName("Hello","World"));
		c.getTime(in);
		
		SecurityTokens st=ExampleService.getLastCallSecurityTokens();
		Assert.assertNotNull(st);
		Object proxy=st.getContext().get(ProxyCertInHandler.PROXY);
		Assert.assertNotNull(proxy);
		Assert.assertTrue(proxy.toString().contains("PRIVATE KEY"));
	}

	private String getBaseurl(){
		return kernel.getContainerProperties().getValue(ContainerProperties.WSRF_BASEURL);
	}
}
