package de.fzj.unicore.uas.notification;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

import org.oasisOpen.docs.wsn.b2.SubscribeDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeDocument;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.client.UASNotificationClient;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xfire.JettyTestCase;
import de.fzj.unicore.wsrflite.xfire.XFireServiceFactory;
import de.fzj.unicore.wsrflite.xmlbeans.WSResource;
import de.fzj.unicore.wsrflite.xmlbeans.client.Consumer;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.ISubscription;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.NotificationConsumer;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.WSRFNotificationProducer;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.impl.NotificationProducerHomeImpl;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.impl.SubscriptionHomeImpl;

public class TestNotificationClient extends JettyTestCase implements Observer {
	
	protected static boolean notified=false;
	
	@Override
	protected void addServices() throws Exception {
		XFireServiceFactory.createAndDeployService(kernel,"NP",WSRFNotificationProducer.class,NotificationProducerHomeImpl.class,false);
		XFireServiceFactory.createAndDeployService(kernel,"Subscription",ISubscription.class,SubscriptionHomeImpl.class, false);
		//test consumer service
		XFireServiceFactory.createAndDeployService(kernel,"Consumer",NotificationConsumer.class,Consumer.class, false);
	}
	
	protected EndpointReferenceType makeConsumer(){
		EndpointReferenceType epr=EndpointReferenceType.Factory.newInstance();
		epr.addNewAddress().setStringValue(getBaseurl()+"/Consumer");
		return epr;
	}
	

	public void test()throws Exception{
		//create a NP instance first
		Home npHome=kernel.getHome("NP");
		String npId=npHome.createWSRFServiceInstance(new HashMap<String,Object>());
		
		//add observer
		Consumer.addObserver(this, WSResource.RPterminationTimeQName);
		
		String xpath=	"declare namespace t='"+TerminationTimeDocument.type.getDocumentElementName().getNamespaceURI()+"';\n"		
			+"declare namespace n='"+SubscribeDocument.type.getDocumentElementName().getNamespaceURI()+"';\n"
			+".//t:TerminationTime[contains(.,'2100')]";
		
		String url=getBaseurl()+"/NP?res="+npId;
		EndpointReferenceType npepr=EndpointReferenceType.Factory.newInstance();
		npepr.addNewAddress().setStringValue(url);
		UASNotificationClient client=new UASNotificationClient(makeConsumer(),url,npepr,kernel.getClientConfiguration());
		
		client.subscribe(WSResource.RPterminationTimeQName,xpath);
		
		//now change TT
		SetTerminationTimeDocument tt=SetTerminationTimeDocument.Factory.newInstance();
		Calendar c=Calendar.getInstance();
		c.set(Calendar.YEAR,2100);
		tt.addNewSetTerminationTime().setRequestedTerminationTime(c);
		WSResource r=(WSResource)npHome.getForUpdate(npId);
		r.SetTerminationTime(tt);
		//force passivate here
		npHome.persist((Resource)r);
		//need to wait a little here
		Thread.sleep(2000);
		
		assertTrue(notified);
		
		notified=false;
		
		//now unsubscribe
		client.unsubscribe(WSResource.RPterminationTimeQName);
		//now change TT
		tt=SetTerminationTimeDocument.Factory.newInstance();
		c=Calendar.getInstance();
		c.set(Calendar.YEAR,2100);
		tt.addNewSetTerminationTime().setRequestedTerminationTime(c);
		r=(WSResource)npHome.getForUpdate(npId);
		r.SetTerminationTime(tt);
		//force passivate here
		npHome.persist((Resource)r);
		//need to wait a little here
		Thread.sleep(2000);
		
		assertFalse(notified);
		
	}
	
	
	public void update(Observable o, Object arg) {
		notified=true;
	}
}
