package de.fzj.unicore.uas.impl.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

import de.fzj.unicore.uas.client.HttpBasicClient;
import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.fts.http.FileServlet;
import de.fzj.unicore.uas.testsuite.RunDate;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.io.IStorageAdapter;

public class TestHttp extends RunDate {

	@Override
	protected void onFinish(JobClient job) throws Exception{
		String jobID=WSUtilities.extractResourceID(job.getEPR());
		//expose the Uspace via the FileServlet
		String id=UUID.randomUUID().toString();
		Configuration config=XNJSFacade.get(null, kernel).getConfiguration();
		Action action=XNJSFacade.get(null, kernel).getAction(jobID);
		IStorageAdapter storage=config.getTargetSystemInterface(null);
		storage.setStorageRoot(action.getExecutionContext().getWorkingDirectory());
		FileServlet.initialise(kernel);
		FileServlet fs=kernel.getAttribute(FileServlet.class);
		fs.exposeDirectory(id, "/", false, storage);

		//try a "get" on a file in uspace
		String accessURL=makeBaseFileURL()+id+"/test.txt";
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		HttpBasicClient hc=new HttpBasicClient(accessURL, job.getSecurityConfiguration());
		hc.readAllData(os);
		System.out.println("Downloaded content: '"+os+"'");

		//try a "get" on a file in a uspace subdirectory
		accessURL=makeBaseFileURL()+id+"/folder/test.txt";
		hc=new HttpBasicClient(accessURL, job.getSecurityConfiguration());
		hc.readAllData(os);
		System.out.println("Downloaded content: '"+os+"'");

		if(doDestroy())job.destroy();
	}

	protected String makeBaseFileURL(){
		String add=null;
		ContainerProperties mainProps = kernel.getContainerProperties(); 
		String host=mainProps.getValue(ContainerProperties.WSRF_HOST);
		String port=mainProps.getValue(ContainerProperties.WSRF_PORT);
		String serv="/files/";
		String proto="http";
		if (kernel.getContainerSecurityConfiguration().isSslEnabled()) {
			proto="https";
		}
		add=proto+"://"+host+":"+port+serv;
		return add;
	}

	protected long read(OutputStream os, GetMethod get, HttpClient client)throws IOException{
		InputStream is=null;
		try{
			int result=client.executeMethod(get);
			//check for 200 response
			if(result<200 || result >299 ){
				throw new IOException("Can't read remote data, server returned "+HttpStatus.getStatusText(result));
			}
			is=get.getResponseBodyAsStream();
			return IOUtils.copy(is, os);
		}finally{
			try{
				if(is!=null)is.close();
			}catch(Exception ignored){}
			get.releaseConnection();
		}
	}
}
