/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 

package de.fzj.unicore.uas.impl;

import java.math.BigInteger;
import java.util.Properties;

import javax.xml.namespace.QName;

import junit.framework.TestCase;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.services.atomic.types.ProtocolDocument;
import org.unigrids.services.atomic.types.ProtocolType;
import org.unigrids.services.atomic.types.StorageReferenceDocument;
import org.unigrids.services.atomic.types.StorageReferenceType;
import org.unigrids.services.atomic.types.StorageTypeEnumeration;
import org.unigrids.services.atomic.types.TextInfoType;
import org.unigrids.x2006.x04.services.tss.ApplicationResourceType;
import org.unigrids.x2006.x04.services.tss.NameDocument;
import org.unigrids.x2006.x04.services.tss.TotalNumberOfJobsDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.fts.UpdatingProtocolRP;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.sms.StorageManagementHomeImpl.StorageTypes;
import de.fzj.unicore.uas.impl.tss.rp.ApplicationsResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.NameResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.NumberOfJobsProperty;
import de.fzj.unicore.uas.impl.tss.rp.StorageReferenceResourceProperty;
import de.fzj.unicore.uas.impl.tss.rp.TextInfoResourceProperty;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.security.TestConfigUtil;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import eu.unicore.jsdl.extensions.MetadataDocument;

/**
 * tests for some target system related resource properties
 */
public class TestRPs extends TestCase {

	private final String metaNS=MetadataDocument.type.getDocumentElementName().getNamespaceURI();
	
	public void testAppsRP1(){
		ApplicationsResourceProperty arp=new ApplicationsResourceProperty(null,null);
		XmlObject[] os =arp.getXml();
		for(XmlObject o:os)System.out.println("rp: "+o);
	}
	
	public void testAppsRP2()throws Exception{
		MetadataDocument meta=MetadataDocument.Factory.parse("<m:Metadata xmlns:m=\""+metaNS+
				"\"><test xmlns=\"nnn\">meta</test></m:Metadata>");
		ApplicationInfo info=new ApplicationInfo();
		System.out.println(meta);
		info.setMetadata(meta);
		info.setApplicationName("test");
		ApplicationsResourceProperty arp=new ApplicationsResourceProperty(null,null);
		ApplicationResourceType art=arp.convertXNJSApp(info);
		assertTrue(art.toString().contains("meta"));
	}
	
	
	public void testAppsRP(){
		ApplicationResourceType app1=ApplicationResourceType.Factory.newInstance();
		app1.setApplicationName("Date");
		ApplicationResourceType app2=ApplicationResourceType.Factory.newInstance();
		app2.setApplicationName("povray");
		
		ApplicationsResourceProperty arp=new ApplicationsResourceProperty(null,null);
		arp.setProperty(new ApplicationResourceType[]{
				app1,app2
		});
		assertNotNull(arp.getXml());
		assertEquals(arp.getXml().length,2);
	}
	
	public void testNameRP() throws Exception{
		NameResourceProperty name=new NameResourceProperty(createMockResource(),"test");
		XmlObject o=name.getXml()[0];
		NameDocument d=(NameDocument)o;
		assertEquals(d.getName(),"test");
	}
	
	public void testNumberOfJobsRP() throws Exception{
		NumberOfJobsProperty jobs=new NumberOfJobsProperty(createMockResource(),null);
		jobs.setProperty(BigInteger.valueOf(323));
		XmlObject o=jobs.getXml()[0];
		TotalNumberOfJobsDocument d=(TotalNumberOfJobsDocument)o;
		assertEquals(d.getTotalNumberOfJobs(),BigInteger.valueOf(323));
	}
	
	public void testStorageRP(){
		EndpointReferenceType epr=EndpointReferenceType.Factory.newInstance();
		epr.addNewAddress().setStringValue("foo");
		StorageReferenceType type=StorageReferenceType.Factory.newInstance();
		type.setStorageEndpointReference(epr);
		type.setType(StorageTypeEnumeration.WORK);
		StorageReferenceResourceProperty srp=new StorageReferenceResourceProperty(
				new StorageReferenceType[]{type});
		assertTrue(srp.getXml().length==1);
		StorageReferenceDocument o=(StorageReferenceDocument)srp.getXml()[0];
		assertEquals(o.getStorageReference().getType(),StorageTypeEnumeration.WORK);
		assertEquals(o.getStorageReference().getStorageEndpointReference().getAddress().getStringValue(),
				"foo");
	}
	
	public void testTextInfoRP() throws Exception{
		Resource wsr=createMockResource();
		wsr.getKernel().getAttribute(UASProperties.class).setProperty(
				UASProperties.TSF_XNJS_CONFIGFILE,"src/test/resources/xnjs.xml");
		TextInfoResourceProperty rp=new TextInfoResourceProperty(wsr,null);
		TextInfoType ti=TextInfoType.Factory.newInstance();
		ti.setName("foo");
		ti.setValue("bar");
		rp.add(ti);
		assertTrue(rp.contains("foo"));
		assertEquals("bar",rp.getInfo("foo"));
		
		//check values defined in "src/test/resources/simpleidb"
		assertTrue(rp.contains("TEST1"));
		assertTrue("This is a test value".equals(rp.getInfo("TEST1")));
		assertTrue(rp.contains("TEST2"));
		assertTrue("This is a second test value".equals(rp.getInfo("TEST2")));
	}

	public void testUpdatingProtocolsRP()throws Exception{
		Resource wsr=createMockResource();
		StorageDescription sd = new StorageDescription("", "foo", "/", StorageTypes.FIXEDPATH, null, "BFT", 
				false, false, false, null, "", null);
		UpdatingProtocolRP rp=new UpdatingProtocolRP(wsr, sd);
		ProtocolType.Enum[]ps=rp.getProperty();
		assertEquals(1, ps.length);
		assertEquals(ProtocolType.BFT, ps[0]);
		ProtocolDocument[]x=rp.getXml();
		assertEquals(1, x.length);
		
		sd.update("BFT UFTP", false, false, null, "", null);
		ps=rp.update().getProperty();
		assertEquals(2, ps.length);
		assertEquals(ProtocolType.BFT, ps[0]);
		assertEquals(ProtocolType.UFTP, ps[1]);
		x=rp.getXml();
		assertEquals(2, x.length);

		//check fallback
		wsr=createMockResource();
		StorageDescription sd2 = new StorageDescription("", "foo", "/", StorageTypes.FIXEDPATH, null, null, 
				false, false, false, null, "", null);
		rp=new UpdatingProtocolRP(wsr, sd2);
		ps=rp.update().getProperty();
		assertEquals(3, ps.length);
		assertEquals(ProtocolType.BFT, ps[0]);
		assertEquals(ProtocolType.RBYTEIO, ps[1]);
		assertEquals(ProtocolType.SBYTEIO, ps[2]);
	}
	
	private Resource createMockResource() throws Exception{
		WSResourceImpl wsr=new WSResourceImpl() {
			@Override
			public QName getResourcePropertyDocumentQName() {
				return null;
			}
		};
		Kernel kernel=new Kernel(TestConfigUtil.getInsecureProperties());
		wsr.setKernel(kernel);
		kernel.setAttribute(UASProperties.class, new UASProperties(new Properties()));
		return wsr;
	}
}