/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 

package de.fzj.unicore.uas.impl;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;

import javax.xml.namespace.QName;

import junit.framework.TestCase;

import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.impl.tss.rp.JobReferenceResourceProperty;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.security.TestConfigUtil;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;

public class TestJobRefRP extends TestCase {

	public void test1() throws Exception{
		JobReferenceResourceProperty j=new JobReferenceResourceProperty(createMockResource());
		EndpointReferenceType epr=EndpointReferenceType.Factory.newInstance();
		epr.addNewAddress().setStringValue("foo");
		j.add(epr);
		assertTrue(j.getXml().length==1);
		epr=EndpointReferenceType.Factory.newInstance();
		epr.addNewAddress().setStringValue("bar");
		j.add(epr);
		assertTrue(j.getXml().length==2);
	}
	
	int n=10000;
	
	public void test3(){
		try{
			JobReferenceResourceProperty j=new JobReferenceResourceProperty(createMockResource());
			for(int i=0;i<n;i++){
				EndpointReferenceType epr=EndpointReferenceType.Factory.newInstance();
				epr.addNewAddress().setStringValue("https://abcd:1234/NNN/services/JobManagement?res=1234567890");
				j.add(epr);
			}
			System.out.println("Job reference property size ("+n+" entries): "+getSize(j)/1000+" kB." );
			timeGetXML(j);
		}catch(Exception e){
			fail(e.getMessage());
		}
	}

	private int getSize(Object o) throws Exception{
		long s=System.currentTimeMillis();
		ByteArrayOutputStream bos=new ByteArrayOutputStream();
		ObjectOutputStream oos=new ObjectOutputStream(bos);
		oos.writeObject(o);
		int size=bos.size();
		oos.close();
		bos.close();
		long f=System.currentTimeMillis();
		System.out.println("Serialization time: "+(f-s)+" millis");
		return size;
	}
	
	private void timeGetXML(ResourceProperty<?> rp) throws Exception{
		long s=System.currentTimeMillis();
		int l=rp.getXml().length;
		long f=System.currentTimeMillis();
		System.out.println("Time for getXml() ("+l+" entries): "+(f-s)+" millis");
	}
	
	private Resource createMockResource() throws Exception{
		Kernel kernel=new Kernel(TestConfigUtil.getInsecureProperties());
		WSResourceImpl wsr=new WSResourceImpl() {
			@Override
			public QName getResourcePropertyDocumentQName() {
				// TODO Auto-generated method stub
				return null;
			}
		};
		wsr.setKernel(kernel);
		return wsr;
	}
}
