package de.fzj.unicore.uas.impl;

import javax.xml.namespace.QName;

import org.apache.xmlbeans.XmlObject;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.Assert;

import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.impl.tss.rp.ExecutionEnvironmentRP;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.security.TestConfigUtil;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import eu.unicore.jsdl.extensions.ExecutionEnvironmentDescriptionDocument;

public class TestExecutionEnvRP {

	static Kernel kernel;
	
	@BeforeClass
	public static void setUp() {
		try
		{
			UAS uas = new UAS(TestConfigUtil.getInsecureProperties());
			kernel = uas.getKernel();
		} catch (Exception e)
		{
			e.printStackTrace();
			Assert.fail(e.toString());
		}
		kernel.getAttribute(UASProperties.class).setProperty(UASProperties.TSF_XNJS_CONFIGFILE, 
				"src/test/resources/xnjs.xml");
		XNJSFacade.get(null,kernel);
	}
	
	@Test
	public void testRP() throws Exception {
		ExecutionEnvironmentRP rp=new ExecutionEnvironmentRP(createMockResource(),null);
		XmlObject[] xml=rp.update().getXml();
		ExecutionEnvironmentDescriptionDocument time=null;
		ExecutionEnvironmentDescriptionDocument mpi=null;
		System.out.println("Number of defined execution environments: "+xml.length);
		Assert.assertEquals(2,xml.length);
		
		for(XmlObject o: xml){
			ExecutionEnvironmentDescriptionDocument eed=(ExecutionEnvironmentDescriptionDocument)o;
			String name=eed.getExecutionEnvironmentDescription().getName();
			if("TIME".equals(name)){
				time=eed;
			}
			else if("OpenMPI".equals(name)){
				mpi=eed;
			}
		}
		checkTimeEE(time);
		checkMPI(mpi);
	}
	
	private void checkTimeEE(ExecutionEnvironmentDescriptionDocument time){
		Assert.assertNotNull(time);
		Assert.assertEquals("1.0",time.getExecutionEnvironmentDescription().getVersion());
	}
	
	private void checkMPI(ExecutionEnvironmentDescriptionDocument mpi){
		Assert.assertNotNull(mpi);
		Assert.assertEquals(1,mpi.getExecutionEnvironmentDescription().getPreCommandArray().length);
	}
	
	
	private Resource createMockResource() throws Exception{
		WSResourceImpl wsr=new WSResourceImpl() {
			@Override
			public QName getResourcePropertyDocumentQName() {
				return null;
			}
		};
		wsr.setKernel(kernel);
		return wsr;
	}
}
