package de.fzj.unicore.uas.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.unigrids.x2006.x04.services.tss.JobReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.Enumeration;
import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.client.EnumerationClient;
import de.fzj.unicore.uas.impl.enumeration.EnumerationHomeImpl;
import de.fzj.unicore.uas.impl.enumeration.EnumerationImpl;
import de.fzj.unicore.uas.impl.tss.rp.JobReferenceResourceProperty;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.Service;
import de.fzj.unicore.wsrflite.ServiceConfiguration;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xfire.LocalTestCase;
import de.fzj.unicore.wsrflite.xfire.XFireServiceFactory;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;

public class TestEnumeration extends LocalTestCase{

	@Override
	protected void addServices() throws Exception {
		ServiceConfiguration c1=XFireServiceFactory.generateServiceConfig(kernel, UAS.ENUMERATION,
				Enumeration.class,EnumerationHomeImpl.class,false);
		Service s1=new XFireServiceFactory().build(c1);
		kernel.getDeploymentManager().deployService(s1);
	}
	
	public void testBasic()throws Exception{
		
		final JobReferenceResourceProperty j=new JobReferenceResourceProperty(createMockResource());

        Map<String,Object>init=new HashMap<String, Object>();
		init.put("targetProperty", j);
		init.put(WSResourceImpl.INIT_UNIQUE_ID, "test");
		EndpointReferenceType tsEPR=EndpointReferenceType.Factory.newInstance();
		tsEPR.addNewAddress().setStringValue("http://test");
		init.put(EnumerationImpl.INIT_TARGETSERVICE_EPR, tsEPR);
		
		Home h=kernel.getHome(UAS.ENUMERATION);
		h.createWSRFServiceInstance(init);
		
		EndpointReferenceType j1=EndpointReferenceType.Factory.newInstance();
		j1.addNewAddress().setStringValue("foo");
		j.add(j1);
		
		EndpointReferenceType j2=EndpointReferenceType.Factory.newInstance();
		j2.addNewAddress().setStringValue("bar");
		j.add(j2);
		
		EndpointReferenceDocument epr=EndpointReferenceDocument.Factory.newInstance();
		epr.addNewEndpointReference().addNewAddress().setStringValue("xfire.local://Enumeration");
		WSServerUtilities.addUGSRefparamToEpr(epr.getEndpointReference(),"test");
		EnumerationClient<JobReferenceDocument> client=
			new EnumerationClient<JobReferenceDocument>(
					epr.getEndpointReference(),
					kernel.getClientConfiguration(),
					JobReferenceDocument.type.getDocumentElementName());
		
		assertEquals(2, client.getNumberOfResults());
		assertNotNull(client.getParentServiceEPR());
		assertEquals("http://test", client.getParentServiceEPR().getAddress().getStringValue());
		
		List<JobReferenceDocument>res=client.getResults(0, 10);
		assertEquals(2, res.size());
	}
	
	public void testIterator()throws Exception{
        final JobReferenceResourceProperty j=new JobReferenceResourceProperty(createMockResource());
		
        Map<String,Object>init=new HashMap<String, Object>();
		init.put("targetProperty", j);
		init.put(WSResourceImpl.INIT_UNIQUE_ID, "test");
		EndpointReferenceType tsEPR=EndpointReferenceType.Factory.newInstance();
		tsEPR.addNewAddress().setStringValue("http://test");
		init.put(EnumerationImpl.INIT_TARGETSERVICE_EPR, tsEPR);

        Home h=kernel.getHome(UAS.ENUMERATION);
		h.createWSRFServiceInstance(init);
		
		EndpointReferenceType j1=EndpointReferenceType.Factory.newInstance();
		j1.addNewAddress().setStringValue("foo");
		j.add(j1);
		
		EndpointReferenceType j2=EndpointReferenceType.Factory.newInstance();
		j2.addNewAddress().setStringValue("bar");
		j.add(j2);
		
		EndpointReferenceDocument epr=EndpointReferenceDocument.Factory.newInstance();
		epr.addNewEndpointReference().addNewAddress().setStringValue("xfire.local://Enumeration");
		WSServerUtilities.addUGSRefparamToEpr(epr.getEndpointReference(),"test");
		EnumerationClient<JobReferenceDocument> client=
			new EnumerationClient<JobReferenceDocument>(
					epr.getEndpointReference(),
					kernel.getClientConfiguration(),
					JobReferenceDocument.type.getDocumentElementName());

		int c=0;
		Iterator<JobReferenceDocument>iter=client.iterator();
		while(iter.hasNext()){
			System.out.println(iter.next().getJobReference().getAddress().getStringValue());
			c++;
		}
		assertEquals(2,c);
		assertEquals(client.getNumberOfResults(),c);
	}
	
	private Resource createMockResource(){
		WSResourceImpl wsr=new WSResourceImpl() {
			@Override
			public QName getResourcePropertyDocumentQName() {
				// TODO Auto-generated method stub
				return null;
			}
		};
		wsr.setKernel(kernel);
		return wsr;
	}
}
