package de.fzj.unicore.uas.impl;

import java.util.HashMap;
import java.util.Map;

import org.junit.After;
import static org.junit.Assert.*;
import org.junit.Test;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.client.TaskClient;
import de.fzj.unicore.uas.impl.task.TaskImpl;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import eu.unicore.bugsreporter.annotation.FunctionalTest;


public class TestAddressUpdate {
	private UAS uas;
	
	@FunctionalTest(id="testAddressUpdate",
		description="Tests that published EPRs change when the server URL is re-configured")
	@Test
	public void testAddressUpdate()throws Exception{
		uas=new UAS("src/test/resources/minimal/wsrflite.xml");
		uas.startSynchronous();
		Kernel kernel=uas.getKernel();
		
		Home taskHome=kernel.getHome(UAS.TASK);
		assertNotNull(taskHome);
		String baseURL=kernel.getContainerProperties().getValue(ContainerProperties.WSRF_BASEURL);
		
		EndpointReferenceType parent=EndpointReferenceType.Factory.newInstance();
		parent.addNewAddress().setStringValue(baseURL+"/foo?res=bar");
		Map<String,Object>initParams=new HashMap<String, Object>();
		initParams.put(TaskImpl.INIT_PARENT_SERVICE, parent);
		String taskID=taskHome.createWSRFServiceInstance(initParams);
		EndpointReferenceType taskEPR=WSServerUtilities.makeEPR(UAS.TASK, taskID, kernel);
		System.out.println(taskEPR);
		TaskClient client=new TaskClient(taskEPR,kernel.getClientConfiguration());
		client.setUpdateInterval(-1);
		EndpointReferenceType submissionRef=client.getResourcePropertiesDocument().getTaskProperties().getSubmissionServiceReference();
		assertNotNull(submissionRef);
		String url=submissionRef.getAddress().getStringValue();
		assertTrue(url.toString().contains("localhost"));
		
		//OK, now change the base URL... and check it is actually changed
		kernel.getContainerProperties().setProperty(ContainerProperties.WSRF_BASEURL, "http://127.0.0.1:65321/services");
		submissionRef=client.getResourcePropertiesDocument().getTaskProperties().getSubmissionServiceReference();
		assertNotNull(submissionRef);
		url=submissionRef.getAddress().getStringValue();
		assertTrue(url, url.toString().contains("127.0.0.1"));
		
	}
	
	@After
	public void tearDown() {
		uas.getKernel().shutdown();
	}
}
