package de.fzj.unicore.client.functional.load;

import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsrf.sg2.AddDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.TargetSystem;
import de.fzj.unicore.wsrflite.xfire.utils.AbstractLoadTester;
import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;

//uses external UAS test installation
public class LoadTestServiceDiscovery extends AbstractLoadTester{

	String url="http://localhost:7777/services/Registry?res=default_registry";
	EndpointReferenceType epr;
	EndpointReferenceType epr1;
	
	@Override
	protected Runnable getTask() {
		return new Runnable(){
			public void run(){
				try{
					RegistryClient c=new RegistryClient(epr, kernel.getClientConfiguration());
					c.listServices(TargetSystem.TSS_PORT);
				}catch(Exception e){
					e.printStackTrace();
				}
			}
		};
	}

	@Override
	protected void setUp() throws Exception {
		LogManager.getLogManager().reset();
		Logger.getLogger("org").setLevel(Level.OFF);
		Logger.getLogger("de").setLevel(Level.OFF);

		statsWriter=new OutputStreamWriter(System.out);
		calls_per_task=1;
		max_num_client_threads=30;
		requests_per_client=5;
		epr=EndpointReferenceType.Factory.newInstance();
		epr.addNewAddress().setStringValue(url);
		epr1=EndpointReferenceType.Factory.newInstance();
		epr1.addNewAddress();
		AddDocument in=AddDocument.Factory.newInstance();
		in.addNewAdd().addNewMemberEPR().addNewAddress().setStringValue("http://foo");
		RegistryClient c=new RegistryClient(epr, kernel.getClientConfiguration());
		System.out.println(in);
		//add some fake entries
		try{
			for(int i=0;i<500;i++){
				if(i%100==0)System.out.println(i+ " entries added.");
				epr1.getAddress().setStringValue(url+i);
				in.getAdd().setContent(RegistryClient.makeContent(
						new XmlObject[]{epr1}));
				c.addRegistryEntry(in);
			}
			}catch(Exception e){
				e.printStackTrace();
			}
	}

	@Override
	protected void addServices() throws Exception {
		
	}
	
	@Override
	protected void tearDown(){}

	
	
}
