package de.fzj.unicore.uas.xnjs;

import org.apache.commons.httpclient.HttpClient;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.http.IConnectionFactory;
import eu.unicore.security.Client;
import eu.unicore.util.httpclient.HttpUtils;
import eu.unicore.util.httpclient.IClientConfiguration;

/**
 * creates HTTP(s) connections for plain http(s) data staging
 * using the UNICORE/X server's key/truststore
 * 
 * @author schuller
 */
public class U6HttpConnectionFactory implements IConnectionFactory{

	private final Kernel kernel;
	
	public U6HttpConnectionFactory(Configuration config){
		this.kernel=config.getComponentInstanceOfType(Kernel.class);
	}

	public HttpClient getConnection(String url, Client client) {
		IClientConfiguration auth=kernel.getClientConfiguration();
		HttpClient http=HttpUtils.createClient(url, auth);
		HttpUtils.configureProxy(http, url, auth.getExtraSettings());
		return http;
	}
}
