package de.fzj.unicore.uas.xnjs;

import java.io.IOException;

import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import eu.unicore.security.Client;

public class TSIStorageAdapterFactory implements StorageAdapterFactory {

	private static final long serialVersionUID = 1L;

	private final String xnjsReference;

	public TSIStorageAdapterFactory(String xnjsReference){
		this.xnjsReference=xnjsReference;
	}


	public IStorageAdapter createStorageAdapter(UASWSResourceImpl parent)throws IOException{
		try{
			Client client=parent.getClient();
			Kernel kernel=parent.getKernel();
			return XNJSFacade.get(xnjsReference,kernel).getConfiguration().getTargetSystemInterface(client);
		}catch(Exception e){
			throw new IOException(e);
		}
	}

}
