/*********************************************************************************
 * Copyright (c) 2006-2008 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 
package de.fzj.unicore.uas.xnjs;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;

import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

import de.fzj.unicore.uas.security.ProxyCertInHandler;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import eu.unicore.security.Client;

/**
 * if available, writes a proxy cert to the uspace in pem format
 *
 * @author schuller
 */
public class ProxyCertToUspaceProcessor extends de.fzj.unicore.xnjs.ems.processors.DefaultProcessor {

	private static final Logger logger = LogUtil.getLogger(LogUtil.SECURITY,ProxyCertToUspaceProcessor.class);
	
	public ProxyCertToUspaceProcessor(Configuration c) {
		super(c);
	}

	protected void handleCreated(){
		try{
			logger.info("Writing proxy cert to uspace");
			Client c=action.getClient();
			String pem=(String)c.getExtraAttributes().get(ProxyCertInHandler.PROXY);
			if(pem==null){
				logger.info("No proxy cert found.");
				return;
			}
			writeToUspace(pem);
		}catch(Exception ex){
			logger.error("Error writing proxy to Uspace",ex);
		}
	}
	
	protected void writeToUspace(String pem)throws Exception{
		String file=action.getExecutionContext().getWorkingDirectory()+".proxy";
		OutputStream os=null;
		try{
			os=configuration.getTargetSystemInterface(action.getClient()).getOutputStream(file);
			ByteArrayInputStream bis=new ByteArrayInputStream(pem.getBytes());
			IOUtils.copy(bis, os);
		}
		finally{
			if(os!=null)os.close();
		}
	}

	//for unit testing
	@SuppressWarnings("all")
	void setAction(final Action a){
		this.action=a;
	}
}
