package de.fzj.unicore.uas.metadata;

import org.apache.log4j.Logger;

import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import eu.unicore.util.Log;

/**
 * factory and configuration class for the metadata support
 * 
 * @author schuller
 */
public class MetadataSupport {

	private static final Logger logger=Log.getLogger(Log.SERVICES, MetadataSupport.class);

	//FIXME Review me: I've changed the logic a bit. static setManagerClass mthod removed (was not used anywhere)
	// no static state anymore 
	//private static Class<? extends MetadataManager>managerClass;

	private MetadataSupport(){}

	/**
	 * get a new instance of the {@link MetadataManager}<br/>
	 * 
	 * The class to be used is read from configuration
	 * 
	 * @return
	 * @throws Exception
	 */
	public static synchronized MetadataManager getManager(Kernel kernel, UASProperties config) {
		
		Class<? extends MetadataManager> managerClass = null;
		try{
			managerClass=config.getClassValue(UASProperties.METADATA_MANAGER_CLASSNAME, MetadataManager.class);
		} catch(Exception ex){
			Log.logException("Shouldn't happen: metadata wrongly configured.", ex, logger);
		}
		
		if (managerClass!=null){
			try{
				MetadataManager mm=kernel.load(managerClass);
				return mm;
			}catch(Exception ex){
				Log.logException("Cannot instatiate metadata manager from class "+managerClass.getName(), ex, logger);
			}
		}
		return null;
	}
	
	public static synchronized MetadataManager getManager(Kernel kernel, IStorageAdapter storage, String uniqueID){
		MetadataManager mm=MetadataSupport.getManager(kernel, kernel.getAttribute(UASProperties.class));
		if(mm instanceof StorageMetadataManager){
			StorageMetadataManager smm=(StorageMetadataManager)mm;
			smm.setStorageAdapter(storage, uniqueID);
		}
		return mm;
	}
}
