package de.fzj.unicore.uas.metadata;

import java.math.BigInteger;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.metadata.ExtractionStatisticsDocument;

import de.fzj.unicore.uas.impl.task.TaskImpl;
import de.fzj.unicore.wsrflite.Kernel;

public class ExtractionWatcher implements Runnable{

	private final String taskID;

	private final Future<ExtractionStatistics>future;

	private final Kernel kernel;
	
	public ExtractionWatcher(Future<ExtractionStatistics>future, String taskID, Kernel kernel){
		this.taskID=taskID;
		this.future=future;
		this.kernel=kernel;
	}
	
	public void run(){
		if(future.isDone()){
			XmlObject result=null;
			try{
				ExtractionStatistics stats=future.get();
				ExtractionStatisticsDocument sd=ExtractionStatisticsDocument.Factory.newInstance();
				sd.addNewExtractionStatistics().setDocumentsProcessed(BigInteger.valueOf(stats.getDocumentsProcessed()));
				sd.getExtractionStatistics().setDurationMillis(BigInteger.valueOf(stats.getDurationMillis()));
				result=sd;
			}
			catch(Exception ex){
				result=TaskImpl.getDefaultResult();
			}
			TaskImpl.putResult(taskID, result);
		}
		else{
			//re-schedule
			kernel.getContainerProperties().getThreadingServices().getScheduledExecutorService().
				schedule(this, 5000, TimeUnit.MILLISECONDS);
		}
	}
}
