/*********************************************************************************
 * Copyright (c) 2008 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 
package de.fzj.unicore.uas.impl.tss.rp;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.tss.XloginDocument;

import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import eu.unicore.security.Xlogin;

/**
 * Support publishing xlogins as TSS/TSF properties.
 * This is needed in case a user has multiple logins and needs to select one

 * @deprecated remove for U7
 */
public class XLoginResourceProperty extends ResourceProperty<Object> {

	private static final long serialVersionUID = 1L;

	private XloginDocument[] xdoc;
	
	public XLoginResourceProperty(ResourceImpl parent) {
		super(parent);
	}

	@Override
	public XmlObject[] getXml() {
		return xdoc;
	}

	public XLoginResourceProperty update(){
		getXlogins();
		return this;
	}
	
	
	private void getXlogins(){
		Xlogin xlogin=((ResourceImpl)parentWSResource).getClient().getXlogin();
		String[] logins=xlogin.getLogins();
		int l=logins!=null?logins.length:0;
		xdoc=new XloginDocument[l];
		if(logins==null)return;
		int i=0;
		for(String xl: logins){
			XloginDocument xLoginDoc=XloginDocument.Factory.newInstance();
			xLoginDoc.setXlogin(xl);
			xdoc[i]=xLoginDoc;
			i++;
		}
	}
}
