/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 

package de.fzj.unicore.uas.impl.tss.rp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.unigrids.x2006.x04.services.tsf.TargetSystemReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

/**
 * holds a set of references to the TargetSystemServices created by a TSF
 * 
 * @author schuller
 */
public class TSSReferenceResourceProperty extends ResourceProperty<EndpointReferenceType[]>{
	
	private static final long serialVersionUID=20348777L;
	
	protected static final Logger logger=Logger.getLogger(LogUtil.SERVICES);
	
	private final List<EndpointReferenceType> eprs;
	
	private TargetSystemReferenceDocument[] xdoc;
	
	public TSSReferenceResourceProperty(EndpointReferenceType[] types){
		super(null);
		eprs=new ArrayList<EndpointReferenceType>();
		xdoc=new TargetSystemReferenceDocument[0];
		setProperty(types);
	}
		
	/**
	 * @param EndpointReferenceType[]
	 */
	@Override
	public void setProperty(EndpointReferenceType[] types) {
		eprs.clear();
		xdoc=new TargetSystemReferenceDocument[types.length];
		for(int i=0;i<types.length;i++){
			eprs.add(types[i]);
			xdoc[i]=TargetSystemReferenceDocument.Factory.newInstance();
			xdoc[i].setTargetSystemReference(types[i]);
		}
	}

	@Override
	public TargetSystemReferenceDocument[] getXml() {
		return xdoc;
	}
	
	public void add(EndpointReferenceType epr){
		synchronized(eprs){
			eprs.add(epr);
			setProperty(eprs.toArray(new EndpointReferenceType[eprs.size()]));
		}
	}
	
	/**
	 * remove an entry by ID
	 * @param id - the id of the TSS to remove
	 */
	public void remove(String id){
		synchronized (eprs) {
			Iterator<EndpointReferenceType> it=eprs.iterator();
			while(it.hasNext()){
				try{
					if(it.next().getAddress().getStringValue().endsWith(id)){
						it.remove();
						logger.debug("Removed "+id);
					}
				}catch(Exception e){
					logger.warn(e.getMessage());
				}
			}
			setProperty(eprs.toArray(new EndpointReferenceType[eprs.size()]));
		}
	}

	@Override
	public EndpointReferenceType[] getProperty() {
		return eprs.toArray(new EndpointReferenceType[eprs.size()]);
	}
	
}
