/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 

package de.fzj.unicore.uas.impl.tss.rp;

import java.util.ArrayList;
import java.util.List;

import org.unigrids.services.atomic.types.StorageReferenceDocument;
import org.unigrids.services.atomic.types.StorageReferenceType;
import org.unigrids.services.atomic.types.StorageTypeEnumeration;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

/**
 * holds a set of references to StorageManagement services
 * 
 * @author schuller
 */
public class StorageReferenceResourceProperty extends ResourceProperty<StorageReferenceType[]> {
	
	private static final long serialVersionUID=20348L;
	   
	private StorageReferenceDocument[] xdoc;

	private final List<StorageReferenceType> types=new ArrayList<StorageReferenceType>();
	
	public StorageReferenceResourceProperty(StorageReferenceType[] types){
		super(null);
		setProperty(types);
	}
	
	public StorageReferenceResourceProperty(EndpointReferenceType[] eprs){
		super(null);
		for(int i=0;i<eprs.length;i++){
			StorageReferenceType t=StorageReferenceType.Factory.newInstance(); 
			t.setStorageEndpointReference(eprs[i]);
			xdoc[i]=StorageReferenceDocument.Factory.newInstance();
			xdoc[i].setStorageReference(t);	
			types.add(t);
		}
	}
	
	@Override
	public void setProperty(StorageReferenceType[] eprs) {
		types.clear();
		xdoc=new StorageReferenceDocument[eprs.length];
		for(int i=0;i<eprs.length;i++){
			xdoc[i]=StorageReferenceDocument.Factory.newInstance();
			xdoc[i].setStorageReference(eprs[i]);
			types.add(eprs[i]);
		}
	}

	/**
	 * append a StorageReference to this resource property
	 * @param epr
	 */
	public synchronized void add(StorageReferenceType epr){
		types.add(epr);
		StorageReferenceDocument[] xdoc1=new StorageReferenceDocument[types.size()];
		int l=xdoc.length;
		System.arraycopy(xdoc,0,xdoc1,0,l);
		xdoc1[xdoc.length]=StorageReferenceDocument.Factory.newInstance();
		xdoc1[xdoc.length].setStorageReference(epr);
		xdoc=xdoc1;
	}
	
	/**
	 * Append a StorageReference to this resource property
	 * The type is set to "Work", if this is not what you want, use
	 * add(StorageReferenceType) instead
	 * @param epr
	 */
	public synchronized void add(EndpointReferenceType epr){
		StorageReferenceDocument sms=StorageReferenceDocument.Factory.newInstance();
		sms.addNewStorageReference().setStorageEndpointReference(epr);
		sms.getStorageReference().setType(StorageTypeEnumeration.WORK);
		add(sms.getStorageReference());
	}
	/**
	 * @return  StorageReferenceType[]
	 */
	@Override
	public StorageReferenceType[] getProperty() {
		return types.toArray(new StorageReferenceType[types.size()]);
	}

	@Override
	public StorageReferenceDocument[] getXml() {
		return xdoc;
	}

}
