package de.fzj.unicore.uas.impl.tss.rp;

import java.util.ArrayList;
import java.util.List;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;
import org.unigrids.services.atomic.types.SiteResourceDocument;
import org.unigrids.services.atomic.types.SiteResourceType;
import org.unigrids.x2006.x04.services.tss.ApplicationResourceType;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.jsdl.IncarnationDataBase;
import de.fzj.unicore.xnjs.jsdl.JSDLResourceSet;
import de.fzj.unicore.xnjs.resources.DoubleResource;
import de.fzj.unicore.xnjs.resources.Resource;
import de.fzj.unicore.xnjs.resources.Resource.Category;
import de.fzj.unicore.xnjs.resources.ResourceSet;

/**
 * support for "old" pre 6.3 way of adding site-specific JSDL range-value-type resources
 * 
 * TODO: remove in next major release
 */
public class SiteSpecificResourcesRP extends IDBBasedResourceProperty<ApplicationResourceType[]>{

	private static final long serialVersionUID = 1L;

	private SiteResourceDocument[] xdoc;

	public SiteSpecificResourcesRP(de.fzj.unicore.wsrflite.Resource res,String xnjsReference) {
		super(res,xnjsReference);
		xdoc = new SiteResourceDocument[0];
	}

	public SiteResourceDocument[] getXml() {
		return xdoc;
	}

	/**
	 * updates information from NJS
	 */
	@Override
	public SiteSpecificResourcesRP update(){
		if(mustUpdate()){
			Kernel kernel=parentWSResource.getKernel();
			IncarnationDataBase idb=XNJSFacade.get(xnjsReference,kernel).getIDB();
			ResourceSet rs=idb.getSiteResources();
			List<SiteResourceDocument>result=new ArrayList<SiteResourceDocument>();
			for(Resource r: rs.getResources()){
				String name=r.getName();
				if(isJSDLResource(name))continue;
				//use only JSDL range value things here...
				if(Category.RANGE_VALUE!=r.getCategory())continue;
				try{
					SiteResourceDocument srd=convert(r);
					if(srd!=null)result.add(srd);
				}catch(Exception e){
					logger.error("Could not process resource : "+r,e);
				}
			}
			xdoc=(SiteResourceDocument[]) result.toArray(new SiteResourceDocument[result.size()]);
		}
		return this;
	}

	private boolean isJSDLResource(String name){
		return JSDLResourceSet.isJSDLResourceName(name);
	}

	private SiteResourceDocument convert(Resource res){
		try{
			DoubleResource r=(DoubleResource)res;
			SiteResourceDocument srd=SiteResourceDocument.Factory.newInstance();
			SiteResourceType sr=srd.addNewSiteResource();
			String name=r.getName();
			sr.setName(name);
			sr.setDescription(r.getDescription());
			RangeValueType val=RangeValueType.Factory.newInstance();

			if(r.getValue()!=null){
				val.addNewExact().setDoubleValue(r.getDoubleValue());
			}
			if(r.getLower()!=null){
				val.addNewRange().addNewLowerBound().setDoubleValue(r.getLower());
				if(r.getUpper()!=null){
					val.getRangeArray(0).addNewUpperBound().setDoubleValue(r.getUpper());
				}
			}
			sr.setValue(val);
			return srd;
		}catch(Exception ex){
			LogUtil.logException("Error converting resource "+res+" to (pre 6.4) site-specific resource document.", ex);
			return null;
		}
	}
}
