package de.fzj.unicore.uas.impl.tss.rp;

import java.math.BigInteger;
import java.util.Map;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.tsf.PerformanceDataDocument;
import org.unigrids.x2006.x04.services.tsf.QueueInfoDocument.QueueInfo;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.xnjs.ems.EMSStatistics;
import eu.unicore.util.Log;

/**
 * publishes performance data
 *
 * @author schuller
 * @since 1.4.0
 */
public class PerformanceDataResourceProperty extends ResourceProperty<Object> {

	private static final long serialVersionUID = 1L;

	private static final Logger logger=Log.getLogger(LogUtil.SERVICES,PerformanceDataResourceProperty.class);

	private final String xnjsReference;
	
	private final PerformanceDataDocument[] xdoc;
	
	public PerformanceDataResourceProperty(Resource parent, String xnjsReference) {
		super(parent);
		this.xnjsReference=xnjsReference;
		xdoc=new PerformanceDataDocument[1];
		xdoc[0]=PerformanceDataDocument.Factory.newInstance();
		xdoc[0].addNewPerformanceData();
	}

	@Override
	public XmlObject[] getXml() {
		return xdoc;
	}
	
	public PerformanceDataResourceProperty update(){
		try{
			Kernel kernel=parentWSResource.getKernel();
			XNJSFacade f=XNJSFacade.get(xnjsReference,kernel);
			EMSStatistics stats=f.getConfiguration().getComponentInstanceOfType(EMSStatistics.class);
			long mtq=stats.getMeanTimeQueued();
			xdoc[0].getPerformanceData().setMeanTimeQueued(BigInteger.valueOf(mtq));
			xdoc[0].getPerformanceData().setTSSType("DEFAULT");
			xdoc[0].getPerformanceData().setQueueInfoArray(new QueueInfo[0]);
			Map<String,Integer>queueFill=f.getQueueFill();
			if(queueFill!=null && queueFill.size()>0){
				for(Map.Entry<String, Integer>e: queueFill.entrySet()){
					QueueInfo qi=xdoc[0].getPerformanceData().addNewQueueInfo();
					qi.setQueueName(e.getKey());
					qi.setActiveJobs(BigInteger.valueOf(e.getValue()));
				}
			}
		}
		catch(Exception ex){
			Log.logException("Can't update performance data", ex, logger);
		}
		return this;
	}

}
