/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 

package de.fzj.unicore.uas.impl.tss.rp;

import java.math.BigInteger;

import org.unigrids.x2006.x04.services.tss.TotalNumberOfJobsDocument;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public class NumberOfJobsProperty extends ResourceProperty<BigInteger> {

	private static final long serialVersionUID=20348L;
	   
	private final TotalNumberOfJobsDocument[] xdoc;
	
	private final TotalNumberOfJobsDocument jobs;

	private final String xnjsReference;

	public NumberOfJobsProperty(Resource parent,String xnjsReference) {
		super(parent);
		jobs = TotalNumberOfJobsDocument.Factory.newInstance();
		jobs.setTotalNumberOfJobs(BigInteger.ZERO);
		xdoc = new TotalNumberOfJobsDocument[]{jobs};
		this.xnjsReference=xnjsReference;
	}
	
	@Override
	public NumberOfJobsProperty update() throws Exception {
		long l=-1;
		try{
			Kernel kernel=parentWSResource.getKernel();
			l=XNJSFacade.get(xnjsReference,kernel).getNumberOfJobs();
		}catch(Exception e){}
		jobs.setTotalNumberOfJobs(BigInteger.valueOf(l));
		return this;
	}


	public TotalNumberOfJobsDocument[] getXml() {
		return xdoc;
	}

	/**
	 * @return BigInteger
	 */
	public BigInteger getProperty() {
		return jobs.getTotalNumberOfJobs();
	}

	/**
	 * sets the total number of jobs
	 * 
	 * @param BigInteger
	 */
	public void setProperty(BigInteger setTo) {
		jobs.setTotalNumberOfJobs(setTo);
	}

}
