/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 

package de.fzj.unicore.uas.impl.tss.rp;

import org.unigrids.x2006.x04.services.tss.NameDocument;

import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

/**
 * A resource property representing the name of the site<br>
 * 
 * @author schuller
 * @version $Id: NameResourceProperty.java,v 1.5 2006/09/08 12:33:48 bschuller Exp $
 */
public class NameResourceProperty extends ResourceProperty<String> {
	protected static final long serialVersionUID=20348L;
	   
	private NameDocument name;

	private NameDocument[] xname;

	public NameResourceProperty(Resource parent) {
		this(parent, parent.getKernel().getContainerProperties().getValue(
				ContainerProperties.VSITE_NAME_PROPERTY));
	}
	
	public NameResourceProperty(Resource parent, String targetSystemName) {
		super(parent);
		if(targetSystemName==null)
			throw new IllegalArgumentException("Target system name must not be null. " +
					"Use default constructor for automatic checking");
		setProperty(targetSystemName);
	}

	public NameDocument[] getXml() {
		return xname;
	}

	public String getProperty() {
		return name.getName();
	}

	public void setProperty(String setTo) {
		name = NameDocument.Factory.newInstance();
		name.setName(setTo);
		xname = new NameDocument[]{name};
	}

}
