package de.fzj.unicore.uas.impl.tss.rp;

import org.apache.log4j.Logger;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

/**
 * a resource property that is based on values from the IDB.
 *
 * @param <T>
 *
 * @author schuller
 * @since 1.2.0
 */
public abstract class IDBBasedResourceProperty<T> extends ResourceProperty<T>{

	private static final long serialVersionUID = 1L;

	protected static final Logger logger=LogUtil.getLogger(LogUtil.SERVICES,IDBBasedResourceProperty.class);

	private long lastIDBUpdate=-1;
	
	protected final String xnjsReference;

	public IDBBasedResourceProperty(Resource parent,String xnjsReference) {
		super(parent);
		this.xnjsReference=xnjsReference;
	}

	/**
	 * checks if the IDB has changed
	 * 
	 * @return true if the IDB has changed since the last call to this method
	 */
	public synchronized boolean mustUpdate(){
		Kernel kernel=parentWSResource.getKernel();
		long idbUpdate=XNJSFacade.get(xnjsReference, kernel).getLastIDBUpdate();
		if(idbUpdate>lastIDBUpdate){
			lastIDBUpdate=idbUpdate;
			if(parentWSResource!=null)((ResourceImpl)parentWSResource).setDirty();
			return true;
		}
		return false;
	}
}
