/*********************************************************************************
 * Copyright (c) 2009 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 

package de.fzj.unicore.uas.impl.tss.rp;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import eu.unicore.jsdl.extensions.ArgumentDocument.Argument;
import eu.unicore.jsdl.extensions.CmdType;
import eu.unicore.jsdl.extensions.ExecutionEnvironmentDescriptionDocument;
import eu.unicore.jsdl.extensions.ExecutionEnvironmentDescriptionDocument.ExecutionEnvironmentDescription;
import eu.unicore.jsdl.extensions.ExecutionEnvironmentDocument.ExecutionEnvironment;
import eu.unicore.jsdl.extensions.OptionMetadataDocument.OptionMetadata;
import eu.unicore.jsdl.extensions.OptionType;

/**
 * represents the execution environments defined in the IDB<br/>
 * 
 * @author schuller
 */
public class ExecutionEnvironmentRP extends IDBBasedResourceProperty<Object> {

	private static final long serialVersionUID = 1L;

	private ExecutionEnvironmentDescriptionDocument[] xdoc=new ExecutionEnvironmentDescriptionDocument[0];
	
	/**
	 * read exec env from the IDB of the given XNJS
	 * @param res -  the parent resource
	 * @param xnjsReference - the XNJS reference 
	 * @see XNJSFacade
	 */
	public ExecutionEnvironmentRP(Resource res, String xnjsReference) {
		super(res,xnjsReference);
	}

	public ExecutionEnvironmentRP update(){
		if(mustUpdate()){
			try{
				Kernel kernel=parentWSResource.getKernel();
				ExecutionEnvironment[] env=XNJSFacade.get(xnjsReference, kernel).getIDB().getExecutionEnvironments();
				xdoc=new ExecutionEnvironmentDescriptionDocument[env.length];
				for(int i=0;i<xdoc.length;i++){
					xdoc[i]=publish(env[i]);
				}
			}catch(Exception e){
				logger.warn("Problem updating ExecutionEnvironment resourceproperty, information is unavailable",e);
				xdoc = new ExecutionEnvironmentDescriptionDocument[0];
			}
		}
		return this;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see de.fzj.unicore.wsrflite.ResourceProperty#getXml()
	 */
	public ExecutionEnvironmentDescriptionDocument[] getXml() {
		return xdoc;
	}

	protected ExecutionEnvironmentDescriptionDocument publish(ExecutionEnvironment orig){
		ExecutionEnvironmentDescriptionDocument result=ExecutionEnvironmentDescriptionDocument.Factory.newInstance();
		ExecutionEnvironmentDescription converted=result.addNewExecutionEnvironmentDescription();
		
		//basic info
		converted.setName(orig.getName());
		String origVersion=orig.getVersion();
		if(origVersion!=null)converted.setVersion(origVersion);
		String origDescription=orig.getDescription();
		if(origDescription!=null)converted.setDescription(origDescription);
		
		//arguments
		int i=0;
		Argument[] convertedArgs=new Argument[orig.getArgumentArray().length];
		for(Argument a: orig.getArgumentArray()){
			convertedArgs[i]=(Argument)a.copy();
			i++;
		}
		converted.setArgumentArray(convertedArgs);
		
		//options and pre/post commands
		converted.setOptionArray(convert(orig.getOptionArray()));
		converted.setPreCommandArray(convert(orig.getPreCommandArray()));
		converted.setPostCommandArray(convert(orig.getPostCommandArray()));
		
		return result;
	} 
	
	protected OptionType[] convert(OptionType[] orig){
		if(orig==null)return new OptionType[0];
		int o=0;
		OptionType[] convertedOpts=new OptionType[orig.length];
		for(OptionType opt: orig){
			convertedOpts[o]=convert(opt);
			o++;
		}
		return convertedOpts;
	}
	
	protected OptionType convert(OptionType option){
		OptionType result=OptionType.Factory.newInstance();
		result.setName(option.getName());
		OptionMetadata meta=option.getOptionMetadata();
		if(meta!=null){
			result.setOptionMetadata((OptionMetadata)meta.copy());
		}
		return result;
	}


	protected CmdType[] convert(CmdType[] orig){
		if(orig==null)return new CmdType[0];
		int o=0;
		CmdType[] convertedOpts=new CmdType[orig.length];
		for(CmdType opt: orig){
			convertedOpts[o]=convert(opt);
			o++;
		}
		return convertedOpts;
	}
	
	protected CmdType convert(CmdType option){
		CmdType result=CmdType.Factory.newInstance();
		result.setName(option.getName());
		OptionMetadata meta=option.getOptionMetadata();
		if(meta!=null){
			result.setOptionMetadata((OptionMetadata)meta.copy());
		}
		return result;
	}
}
