/*********************************************************************************
 * Copyright (c) 2006-2007 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 

package de.fzj.unicore.uas.impl.tss.rp;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.IndividualCPUCountDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import eu.unicore.security.Client;

/**
 * represents the number of CPUs per node on a 
 * TargetSystem or TargetSystemFactory resource<br>
 */
public class CPUCountResourceProperty extends IDBBasedResourceProperty<Object> {

	private static final long serialVersionUID = -1641168248769350917L;

	private IndividualCPUCountDocument[] xdoc;
	
	public CPUCountResourceProperty(Resource res, String xnjsReference) {
		super(res,xnjsReference);
	}

	/**
	 * updates application information from NJS
	 */
	public CPUCountResourceProperty update(){
		if(mustUpdate()){
			try{
				Kernel kernel=parentWSResource.getKernel();
				Client client = ((ResourceImpl) parentWSResource).getClient();
				ResourcesType res = XNJSFacade.get(xnjsReference, kernel).getResources(client);
				IndividualCPUCountDocument cput=IndividualCPUCountDocument.Factory.newInstance();
				RangeValueType cpuCount = res.getIndividualCPUCount();
				if(cpuCount == null) {
					logger.debug("IndividualCPUCount not set in IDB.");
					xdoc = new IndividualCPUCountDocument[0];
				}
				else{
					xdoc = new IndividualCPUCountDocument[1];
					cput.setIndividualCPUCount(cpuCount);
					xdoc[0]=cput;
				}
			}catch(Exception e){
				logger.warn("Problem updating CPUTime resourceproperty.",e);
				xdoc = new IndividualCPUCountDocument[0];
			}
		}
		return this;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see de.fzj.unicore.wsrflite.ResourceProperty#getXml()
	 */
	public IndividualCPUCountDocument[] getXml() {
		return xdoc;
	}

}
