package de.fzj.unicore.uas.impl.tss;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.impl.job.JobManagementImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.InternalAction;
import eu.unicore.security.Client;

/**
 * re-create JMS instances from XNJS jobs
 * 
 * @author schuller
 */
public class GenerateJMSInstances implements Runnable{

	private final Logger logger=LogUtil.getLogger(LogUtil.SERVICES, GenerateJMSInstances.class);

	private final String tssID;

	private final Client client;

	private final String xnjsReference;

	private final Home tssHome;

	private final Home jms;

	private final Set<String>existingJobs;

	private final List<String>jobIDs;

	private final Kernel kernel;
	
	public GenerateJMSInstances(Kernel kernel, String tssID, Client client, String xnjsReference)throws Exception{
		this.kernel=kernel;
		this.tssID=tssID;
		this.client=client;
		this.xnjsReference=xnjsReference;
		this.tssHome=kernel.getHome(UAS.TSS);
		this.jms=kernel.getHome(UAS.JMS);
		this.existingJobs=getExistingJobs();
		this.jobIDs=getXNJSJobs();
	}

	List<String>getXNJSJobs()throws Exception{
		XNJSFacade xnjs=XNJSFacade.get(xnjsReference, kernel);
		return xnjs.listJobIDs(client);
	}
	
	public void run(){
		try{
			logger.info("Regenerating UNICORE jobs for "+client.getDistinguishedName());
			XNJSFacade xnjs=XNJSFacade.get(xnjsReference, kernel);
			for(String jobID: jobIDs){
				Action action=xnjs.getAction(jobID);
				if(action==null)continue;
				if(accept(action) && !jobExists(jobID)){
					try{
						add(action);
					}catch(Exception ex){
						logger.error("Could not restore job for : "+action.getUUID(),ex);
					}
				}
			}
		}catch(Exception ex){
			logger.error("Could not restore jobs for "+client,ex);
		}
	}

	protected boolean accept(Action action){
		//do not accept internal actions
		if(action instanceof InternalAction){
			return false;
		}
		//only accept jsdl actions
		String type=action.getType();
		if(!"JSDL".equals(type))return false;
		//and those which belong to the current user
		String owner=action.getClient().getDistinguishedName();
		return client.getDistinguishedName().equalsIgnoreCase(owner);
	}

	protected boolean jobExists(String uid){
		return existingJobs.contains(uid);
	}

	protected void add(Action action)throws Exception{
		TargetSystemImpl tss=(TargetSystemImpl)tssHome.getForUpdate(tssID);
		try{
			Map<String,Object> map=new HashMap<String,Object>();
			map.put(JobManagementImpl.INITPARAM_ACTION,action);
			map.put(JobManagementImpl.INITPARAM_ACTION_NO_XNJS_SUBMIT,Boolean.TRUE);
			map.put(JobManagementImpl.INITPARAM_TSS_UNIQUEID, tssID);
			map.put(TargetSystemImpl.INITPARAM_XNJS_REFERENCE, xnjsReference);
			tss.createJob(map);
		}finally{
			if(tss!=null){
				tssHome.persist(tss);
			}
		}
	}

	private Set<String>getExistingJobs()throws PersistenceException{
		return jms.getStore().getUniqueIDs();
	}

}
