package de.fzj.unicore.uas.impl.task;

import java.math.BigInteger;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.services.atomic.types.StatusInfoDocument;
import org.unigrids.services.atomic.types.StatusInfoType;

import de.fzj.unicore.uas.impl.task.TaskImpl.TaskStatus;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public class StatusRP extends ResourceProperty<XmlObject> {
	
	private static final long serialVersionUID=1L;
	
	public StatusRP(TaskImpl parent){
		super(parent);
	}
	
	@Override
	public XmlObject[] getXml() {
		StatusInfoDocument d=StatusInfoDocument.Factory.newInstance();
		try{
			String uuid=parentWSResource.getUniqueID();
			TaskStatus state=TaskImpl.getStatus(uuid);
			StatusInfoType statusInfo=d.addNewStatusInfo();
			statusInfo.setStatus(state.status);
			if(state.message!=null)statusInfo.setDescription(state.message);
			if(state.progress!=null)statusInfo.setProgress(state.progress);
			if(state.exitCode!=null)statusInfo.setExitCode(BigInteger.valueOf(state.exitCode));
		}catch(Exception re){
			throw new IllegalStateException(re);
		}
		return new XmlObject[]{d};
	}
}

