package de.fzj.unicore.uas.impl.task;

import org.apache.xmlbeans.XmlObject;

import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import eu.unicore.unicore6.task.ResultDocument;

public class ResultRP extends ResourceProperty<XmlObject> {

	private static final long serialVersionUID=1L;

	private ResultDocument result;

	public ResultRP(TaskImpl parent){
		super(parent);
	}

	@Override
	public XmlObject[] getXml() {
		if(result==null){
			ResultDocument d=ResultDocument.Factory.newInstance();
			try{
				String uuid=parentWSResource.getUniqueID();
				XmlObject o=TaskImpl.getAndRemoveResult(uuid);
				if(o==null){
					return new XmlObject[0];
				}
				else{
					d.addNewResult().set(o);
					result=d;
					((ResourceImpl)parentWSResource).setDirty();
				}
			}catch(Exception re){
				throw new IllegalStateException(re);
			}
		}
		return new XmlObject[]{result};
	}

}
