package de.fzj.unicore.uas.impl.sms;

import java.io.File;
import java.util.Map;

import org.apache.log4j.Logger;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.tsi.TSI;

/**
 * a storage where the path is resolved once per request. This allows
 * having environment variables in the path specification, for
 * example /work/$PROJECT/files
 * 
 * @author schuller
 */
public class PathedStorageImpl extends SMSBaseImpl {

	private static final Logger logger=LogUtil.getLogger(LogUtil.SERVICES,PathedStorageImpl.class);

	protected String storageRoot;

	public static String INIT_SKIP_RESOLVE=PathedStorageImpl.class.getName()+"_skip_initial_resolve";

	public PathedStorageImpl() {
		super();
	}

	@Override
	protected void smsPostActivate(){
		//make sure the storageRoot is resolved once per request
		storageRoot=null;
	}

	@Override
	protected synchronized String getStorageRoot() {
		if(storageRoot==null){
			try{
				resolveRootDir();
			}
			catch(ExecutionException e){
				LogUtil.logException("Could not resolve location: "+workdir,e,logger);
				return workdir;
			}
		}
		return storageRoot;
	}

	private void resolveRootDir()throws ExecutionException{
		TSI tsi=XNJSFacade.get(xnjsReference,kernel).getTSI(getClient());
		storageRoot=tsi.resolve(workdir);
		if(tsi.isLocal()){
			//make sure it is absolute
			storageRoot=new File(storageRoot).getAbsolutePath();
		}
		//check if the resolved dir is just "/", and fail in this case
		if(getSeparator().equals(storageRoot)){
			throw new ExecutionException("Variable path was resolved to '/', this is not allowed");
		}
	}

	@Override
	public void initialise(String name, Map<String, Object> initobjs) throws Exception {
		super.initialise(name, initobjs);
		workdir=storageDescription.getPathSpec();
		if(workdir==null)throw new IllegalArgumentException("Work directory cannot be null.");
		if(!workdir.endsWith(getSeparator()))workdir+=getSeparator();

		//try to resolve once to detect problems early
		if(!Boolean.TRUE.equals(initobjs.get(INIT_SKIP_RESOLVE))){
			resolveRootDir();
		}
		if(storageRoot!=null){
			logger.info("SMS init in <"+workdir+"> resolved as <"+storageRoot+">");
			if(!Boolean.TRUE.equals(initobjs.get(SMSBaseImpl.INIT_SKIP_EXISTENCECHECK))){
				checkDirExists();
			}
		}
		else{
			logger.info("SMS init in <"+workdir+">");
		}
	}

	private void checkDirExists()throws ExecutionException{
		TSI tsi=XNJSFacade.get(xnjsReference,kernel).getTSI(getClient());
		//some sanity checks
		XnjsFileWithACL xnjsFile=tsi.getProperties(storageRoot);
		if(xnjsFile==null){
			throw new ExecutionException("Directory '"+storageRoot+"' does not exist.");
		}
		if(!xnjsFile.isDirectory()){
			throw new ExecutionException("Path '"+storageRoot+"' is not a directory.");
		}
	}
}
