package de.fzj.unicore.uas.impl.sms;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;

import org.apache.log4j.Logger;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.impl.LockSupport;
import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.exceptions.ResourceNotCreatedException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;

public class InitDefaultStorageFactory implements Runnable{

	private static final Logger logger=LogUtil.getLogger(LogUtil.UNICORE,InitDefaultStorageFactory.class);

	private final Kernel kernel;
	
	public InitDefaultStorageFactory(Kernel kernel){
		this.kernel=kernel;
	}
	
	public void run(){
		try{
			createDefaultStorageFactoryIfNotExists();
		} catch (Exception e) {
			throw new RuntimeException("Could not setup default storage factory.",e);
		}
	}

	/**
	 * add a "default" storage factory if it does not yet exist	
	 */
	protected void createDefaultStorageFactoryIfNotExists()throws ResourceNotCreatedException,PersistenceException{
		Home smfHome=kernel.getHome(UAS.SMF);
		if(smfHome==null){
			logger.info("No StorageFactory service configured for this site!");
			return;
		}
		//get "global" lock
		LockSupport ls=kernel.getPersistenceManager().getLockSupport();
		Lock smfLock=ls.getOrCreateLock(InitDefaultStorageFactory.class.getName());
		String defaultSmfName=StorageFactoryHomeImpl.DEFAULT_SMF_NAME;
		if(smfLock.tryLock()){
			try{
				try{
					//this will throw ResourceUnknowException if resource does not exist
					smfHome.get(defaultSmfName);
					UASWSResourceImpl smf=(UASWSResourceImpl)smfHome.get(defaultSmfName);
					//It exists, so force re-publish
					smf.publish();
					//exists, so we are done
					return;
				}
				catch(ResourceUnknownException e){}
				doCreateSMF(smfHome);
			}finally{
				smfLock.unlock();
			}
		}
	}

	private void doCreateSMF(Home smfHome)throws ResourceNotCreatedException{
		String defaultSmfName=StorageFactoryHomeImpl.DEFAULT_SMF_NAME;
		Map<String,Object>imap=new HashMap<String,Object>();
		imap.put(WSResourceImpl.INIT_UNIQUE_ID,defaultSmfName);
		//set lifetime to 36 months...
		Calendar c=new GregorianCalendar();
		c.add(Calendar.MONTH,36);
		imap.put(WSResourceImpl.INIT_INITIAL_TERMINATION_TIME,c);
		smfHome.createWSRFServiceInstance(imap);
		logger.info("Added default StorageFactory resource "+defaultSmfName+".");
	}

}
