package de.fzj.unicore.uas.impl.sms;

import java.util.Map;

import org.apache.log4j.Logger;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import eu.unicore.security.Client;

/**
 * Represents a HOME storage. The storage root is the current user's 
 * home directory on the target system.
 * @author schuller
 *
 */
public class HomeStorageImpl extends SMSBaseImpl {

	private static final Logger logger=LogUtil.getLogger(LogUtil.SERVICES,HomeStorageImpl.class);

	private transient String homeDirectory=null;

	public HomeStorageImpl() {
		super();
	}

	@Override
	public void initialise(String name, Map<String,Object>initobjs)throws Exception{
		super.initialise(name, initobjs);
		//important - detect problems with establishing HOME dir from XNJS/TSI early.
		setHome();
	}

	private void setHome() throws ExecutionException {
		Client client=getClient();
		
		homeDirectory=XNJSFacade.get(xnjsReference,kernel).getGrounder().
				incarnatePath("","HOME",null,client);
		if(logger.isDebugEnabled()){
			String xlogin="n/a";
			String dn = "unknown";
			if(client!= null && client.getXlogin().getUserName() != null){
				xlogin=client.getXlogin().getUserName();
			}
			if (client!= null && client.getDistinguishedName() != null)
				dn = client.getDistinguishedName();
			logger.debug("Got home directory for "+
					dn
					+" xlogin='"+xlogin+"'"
					+": <"+homeDirectory+">");
		}
		//check if the resolved dir is just "/", and fail in this case
		if(getSeparator().equals(homeDirectory)){
			throw new ExecutionException("No proper HOME can be determined");
		}
		
		if (!homeDirectory.endsWith(getSeparator())) 
			homeDirectory = homeDirectory + getSeparator();
	}

	@Override
	protected String getStorageRoot()throws ExecutionException{
		if (homeDirectory == null) {
			try {
				setHome();
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		}
		return homeDirectory;
	}

	@Override
	protected void smsPostActivate() {
		homeDirectory=null;
	}
}
