package de.fzj.unicore.uas.impl.sms;

import java.io.File;
import java.util.Map;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.tsi.TSI;

/**
 * A storage serving files from a fixed path, such as "/work" 
 * 
 * @author schuller
 */
public class FixedStorageImpl extends SMSBaseImpl {

	public FixedStorageImpl() {
		super();
	}
	
	@Override
	public void initialise(String name, Map<String,Object>initobjs)throws Exception{
		super.initialise(name, initobjs);
		workdir=storageDescription.getPathSpec();
		if(workdir==null)throw new IllegalArgumentException("Work directory cannot be null.");
		TSI tsi=XNJSFacade.get(xnjsReference,kernel).getTSI(getClient());
		if(tsi!=null && tsi.isLocal()){
			workdir=new File(workdir).getAbsolutePath();
		}
		if(!workdir.endsWith(getSeparator()))workdir+=getSeparator();
		if(Boolean.TRUE.equals(initobjs.get(SMSBaseImpl.INIT_DIRECTORY_APPEND_UNIQUE_ID))){
			workdir=workdir+getUniqueID();
		}
		if(!Boolean.TRUE.equals(initobjs.get(SMSBaseImpl.INIT_SKIP_EXISTENCECHECK))){
			checkWorkdirExists();
		}
	}
	
	private void checkWorkdirExists()throws ExecutionException{
		TSI tsi=XNJSFacade.get(xnjsReference,kernel).getTSI(getClient());
		//some sanity checks
		XnjsFileWithACL xnjsFile=tsi.getProperties(workdir);
		if(xnjsFile==null){
			throw new ExecutionException("Directory '"+workdir+"' does not exist.");
		}
		if(!xnjsFile.isDirectory()){
			throw new ExecutionException("Path '"+workdir+"' is not a directory.");
		}
	}

	@Override
	protected String getStorageRoot() {
		return workdir;
	}
	
}
