package de.fzj.unicore.uas.impl.sms;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.ExactType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemTypeEnumeration;

import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.xnjs.io.XnjsStorageInfo;

//FIXME - this and DefaultStorageInfoProvider should have a common (at least mostly) code
public class FileSystemRP extends ResourceProperty<Object>{
	
	private static final long serialVersionUID=1L;
	   
	private final FileSystemDocument[] xdoc;
	
	public FileSystemRP(ResourceImpl parent, String name){
		super(parent);
		FileSystemDocument fs=FileSystemDocument.Factory.newInstance();
		fs.addNewFileSystem().setName(name);
		fs.getFileSystem().setFileSystemType(FileSystemTypeEnumeration.NORMAL);
		xdoc=new FileSystemDocument[]{fs};
	}
	
	@Override
	public ResourceProperty<Object> update() throws Exception {
		FileSystemDocument fs=xdoc[0];
		SMSBaseImpl parent=(SMSBaseImpl)parentWSResource;
		String description=parent.getStorageAdapter().getFileSystemIdentifier();
		String root=parent.getStorageRoot();
		if(description!=null){
			fs.getFileSystem().setDescription(description);
		}
		if(root!=null){
			fs.getFileSystem().setMountPoint(root);
		}
		if(root==null)root=".";
		//FIXME - what about total space? Also distinguishing those tow would be nice.
		XnjsStorageInfo info=parent.getStorageAdapter().getAvailableDiskSpace(root);
		if(info.getUsableSpace()>-1){
			getOrCreateDiskSpaceValue(fs).setDoubleValue(info.getUsableSpace());
		}
		else if(info.getFreeSpace()>-1){
			getOrCreateDiskSpaceValue(fs).setDoubleValue(info.getFreeSpace());
		}
		return this;
	}

	private ExactType getOrCreateDiskSpaceValue(FileSystemDocument fs){
		if(fs.getFileSystem().getDiskSpace()==null){
			fs.getFileSystem().addNewDiskSpace();
		}
		if(fs.getFileSystem().getDiskSpace().getExactArray().length==0){
			fs.getFileSystem().getDiskSpace().addNewExact();
		}
		return fs.getFileSystem().getDiskSpace().getExactArray()[0];
	}

	@Override
	public FileSystemDocument[] getXml() {
		return xdoc;
	}
	
}
