package de.fzj.unicore.uas.impl.sms;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemDocument;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.io.XnjsStorageInfo;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;

/**
 * FIXME - this and {@link FileSystemRP} should have a common (at least mostly) code
 * provides information about the storage backed by a filesystem
 */
public class DefaultStorageInfoProvider implements StorageInfoProvider {

	private final Kernel kernel;
	
	public DefaultStorageInfoProvider(Kernel kernel){
		this.kernel = kernel;
	}
	
	public FileSystemDocument getInformation(StorageDescription factoryDesc, Client client, String xnjsRef) {
		FileSystemDocument fs=FileSystemDocument.Factory.newInstance();
		
		String workdir=factoryDesc.getPathSpec();
		if (workdir != null) {
			TSI tsi=XNJSFacade.get(xnjsRef,kernel).getTSI(client);
			XnjsStorageInfo info=tsi.getAvailableDiskSpace(workdir);
			fs.addNewFileSystem().setMountPoint(workdir);
			//FIXME - This is rather broken. 
			//FIXME - does it make sense? How one can distinguish free from usable? What about total
			if(info.getUsableSpace()>-1){
				fs.getFileSystem().addNewDiskSpace().addNewExact().setDoubleValue(info.getUsableSpace());
			}
			else if(info.getFreeSpace()>-1){
				fs.getFileSystem().addNewDiskSpace().addNewExact().setDoubleValue(info.getFreeSpace());
			}
		}
		
		fs.getFileSystem().setDescription(factoryDesc.getDescription());
		
		return fs;	
	}
}
