/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 

package de.fzj.unicore.uas.impl.sms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.unigrids.x2006.x04.services.smf.AccessibleStorageReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.wsrflite.impl.SecuredResourceImpl;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import eu.unicore.security.Client;
import eu.unicore.security.OperationType;

/**
 * Filtered set of references to Storage Management Services created by the StorageFactory
 * Only "accessible" instances are listed!
 *
 * @author schuller
 */
public class AccessibleSMSReferenceRP extends  ResourceProperty<EndpointReferenceType[]>{
	
	private static final long serialVersionUID=1L;
	
	public AccessibleSMSReferenceRP(StorageFactoryImpl parent){
		super(parent);
	}

	@Override
	public AccessibleStorageReferenceDocument[] getXml() {
		StorageFactoryImpl parent=((StorageFactoryImpl)parentWSResource);
		Client c=AuthZAttributeStore.getClient(); 
		List<AccessibleStorageReferenceDocument>xdoc=new ArrayList<AccessibleStorageReferenceDocument>();
		EndpointReferenceType[] eprs=parent.getSMSReferenceProperty().getProperty();
		for(int i=0;i<eprs.length;i++){
			if(isAccessible(eprs[i],c, parent)){
				AccessibleStorageReferenceDocument d=AccessibleStorageReferenceDocument.Factory.newInstance();
				d.setAccessibleStorageReference(eprs[i]);
				xdoc.add(d);
			}
		}
		return xdoc.toArray(new AccessibleStorageReferenceDocument[xdoc.size()]);
	}
	
	//checks whether the local service referenced by epr is accessible
	protected boolean isAccessible(EndpointReferenceType epr, Client c, StorageFactoryImpl parent){
		try{
			String wsResourceID=WSServerUtilities.extractResourceID(epr);
			String ownerDN=parent.getOwnerForSMS(wsResourceID);
			Map<String, Set<OperationType>> voMembership = ((SecuredResourceImpl)parentWSResource).getVOMembership();			
			return parentWSResource.getKernel().getSecurityManager().isAccessible(c, UAS.SMS, 
					wsResourceID, ownerDN, voMembership);
		}catch(Exception ex){}
		return false;
	}
	
}
