package de.fzj.unicore.uas.impl.sms;

import org.unigrids.x2006.x04.services.sms.ACLSupportedDocument;

import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public class ACLSupportedRP extends ResourceProperty<Object>{
	
	private static final long serialVersionUID=1L;
	   
	private final ACLSupportedDocument[] xdoc;
	
	public ACLSupportedRP(ResourceImpl parent, String name){
		super(parent);
		ACLSupportedDocument acl = ACLSupportedDocument.Factory.newInstance();
		xdoc=new ACLSupportedDocument[]{acl};
	}
	
	@Override
	public ResourceProperty<Object> update() throws Exception {
		ACLSupportedDocument acl = xdoc[0];
		SMSBaseImpl parent = (SMSBaseImpl)parentWSResource;
		boolean supported = parent.getStorageAdapter().isACLSupported("/");
		acl.setACLSupported(supported);
		return this;
	}

	@Override
	public ACLSupportedDocument[] getXml() {
		return xdoc;
	}
}
