package de.fzj.unicore.uas.impl.rns;

import java.util.Calendar;

import javax.xml.namespace.QName;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.GDate;
import org.apache.xmlbeans.GDateBuilder;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsrf.rl2.DestroyDocument;
import org.oasisOpen.docs.wsrf.rl2.DestroyResponseDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.DeleteResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.DeleteResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.DeleteType;
import org.oasisOpen.docs.wsrf.rp2.GetMultipleResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.GetMultipleResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentDocument1;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.InsertResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.InsertResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.InsertType;
import org.oasisOpen.docs.wsrf.rp2.PutResourcePropertyDocumentDocument1;
import org.oasisOpen.docs.wsrf.rp2.PutResourcePropertyDocumentResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.QueryResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.QueryResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.SetResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.SetResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateType;

import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSResource;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.InvalidResourcePropertyQNameFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.TerminationTimeChangeRejectedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.UnableToSetTerminationTimeFault;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import eu.unicore.util.Log;


/**
 * This class handles the case where a single "real" WS-Resource mimics the
 * existence of multiple virtual WS-Resources that form an RNS tree. 
 * A common scenario in which this is useful is an RNS-based storage where each
 * file/folder looks like a WS-Resource from the outside, but in fact, only the
 * storage itself is a persistent Unicore WS-Resource. This is sometimes called
 * a "resource fork". The scenario implies that incoming WSRF operations
 * received by the storage must be "multiplexed", i.e. routed to the right file.
 * For example, if someone calls "destroy" on a virtual file WS-Resource, the
 * storage MUST NOT be destroyed, but delete the file instead.
 * @author bdemuth
 *
 */
public class WSRFMethodMultiplexer implements WSResource {

	protected static final Logger logger=Log.getLogger(Log.SERVICES,WSResourceImpl.class);

	private RNSNodeWSRFHandler handler;
	private RNSSupport rnsSupport;
	private WSResource parent;

	@Override
	public DestroyResponseDocument Destroy(DestroyDocument in)
	throws ResourceNotDestroyedFault, ResourceUnknownFault,
	ResourceUnavailableFault {
		if(requestAimsAtParent())
		{
			//that's the parent! => it will be DESTROYED
			return getParent().Destroy(in);
		}
		else
		{
			RNSNode child = getRequestedNode();
			try{
				handler.destroy(child);
				DestroyResponseDocument drd=DestroyResponseDocument.Factory.newInstance();
				drd.addNewDestroyResponse();
				return drd;
			}catch(Exception e){
				Log.logException("Error during resource destruction.",e,logger);
				throw ResourceNotDestroyedFault.createFault(e.getMessage());
			}
		}
	}

	@Override
	public SetTerminationTimeResponseDocument SetTerminationTime(
			SetTerminationTimeDocument in)
	throws UnableToSetTerminationTimeFault,
	TerminationTimeChangeRejectedFault, ResourceUnknownFault,
	ResourceUnavailableFault {
		if(requestAimsAtParent())
		{
			//that's the parent!
			return getParent().SetTerminationTime(in);
		}
		else
		{
			RNSNode child = getRequestedNode();
			Calendar c = null;
			if(!in.getSetTerminationTime().isNilRequestedTerminationTime()){
				c=in.getSetTerminationTime().getRequestedTerminationTime();
				GDuration d=in.getSetTerminationTime().getRequestedLifetimeDuration();
				if(d!=null){
					c=Calendar.getInstance();
					GDateBuilder b=new GDateBuilder(c);
					b.addGDuration(d);
					GDate date=b.toGDate();
					c.setTime(date.getDate());

				}
				if(c!=null){
					handler.setTerminationTime(child,c);

				}
				else throw UnableToSetTerminationTimeFault.createFault("Illegal arguments to SetTerminationTime.");
			}
			else{
				//infinite lifetime
				handler.setTerminationTime(child,null);

			}
			//make the response doc...
			SetTerminationTimeResponseDocument response=SetTerminationTimeResponseDocument.Factory.newInstance();

			response.addNewSetTerminationTimeResponse().
			setNewTerminationTime((Calendar)c);
			response.getSetTerminationTimeResponse().setCurrentTime(Calendar.getInstance());

			return response;
		}
	}


	@Override
	public DeleteResourcePropertiesResponseDocument DeleteResourceProperties(
			DeleteResourcePropertiesDocument in) throws ResourceUnknownFault,
			ResourceUnavailableFault, BaseFault {
		if(requestAimsAtParent())
		{
			//that's the parent!
			return getParent().DeleteResourceProperties(in);
		}
		else
		{
			RNSNode child = getRequestedNode();
			try {
				DeleteType delete=in.getDeleteResourceProperties().getDelete();
				QName q = delete.getResourceProperty();
				handler.deleteResourceProperties(child,q);	
			} catch (NullPointerException e) {
				throw BaseFault.createFault("Missing arguments",e);
			}
			
		}
		DeleteResourcePropertiesResponseDocument res=DeleteResourcePropertiesResponseDocument.Factory.newInstance();
		res.addNewDeleteResourcePropertiesResponse();
		return res;
	}

	@Override
	public PutResourcePropertyDocumentResponseDocument PutResourcePropertyDocument(
			PutResourcePropertyDocumentDocument1 in)
	throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault {
		if(requestAimsAtParent())
		{
			//that's the parent!
			return getParent().PutResourcePropertyDocument(in);
		}
		else
		{
			throw BaseFault.createFault("Not implemented.");
		}
	}

	@Override
	public InsertResourcePropertiesResponseDocument InsertResourceProperties(
			InsertResourcePropertiesDocument in) throws ResourceUnknownFault,
			ResourceUnavailableFault, BaseFault {
		if(requestAimsAtParent())
		{
			//that's the parent!
			return getParent().InsertResourceProperties(in);
		}
		else
		{
			RNSNode child = getRequestedNode();
			try{
				InsertType insert=in.getInsertResourceProperties().getInsert();
				QName q=WSUtilities.findAnyElementQName(insert);
				XmlObject[] rpChange=WSUtilities.extractAnyElements(insert, q);
				handler.insertResourceProperty(child, rpChange);
				InsertResourcePropertiesResponseDocument res=InsertResourcePropertiesResponseDocument.Factory.newInstance();
				res.addNewInsertResourcePropertiesResponse();
				return res;
			}
			catch(Exception e){
				throw BaseFault.createFault("Modifications are not valid.", e, true);	
			}
			
		}
	}

	@Override
	public GetResourcePropertyDocumentResponseDocument GetResourcePropertyDocument(
			GetResourcePropertyDocumentDocument1 in) throws BaseFault,
			ResourceUnknownFault, ResourceUnavailableFault {
		if(requestAimsAtParent())
		{
			//that's the parent!
			return getParent().GetResourcePropertyDocument(in);
		}
		else
		{
			return createResource().GetResourcePropertyDocument(in);
		}
	}

	@Override
	public UpdateResourcePropertiesResponseDocument UpdateResourceProperties(
			UpdateResourcePropertiesDocument in) throws ResourceUnknownFault,
			ResourceUnavailableFault, BaseFault {
		
		if(requestAimsAtParent())
		{
			//that's the parent!
			return getParent().UpdateResourceProperties(in);
		}
		else
		{
			
			RNSNode child = getRequestedNode();
			try{
				UpdateType update=in.getUpdateResourceProperties().getUpdate();
				QName q=WSUtilities.findAnyElementQName(update);
				if(q==null){
					throw BaseFault.createFault("Invalid update request, qname is null.");
				}
				XmlObject[] rpChange=WSUtilities.extractAnyElements(update, q);
				handler.updateResourceProperty(child, q, rpChange);
				UpdateResourcePropertiesResponseDocument res=UpdateResourcePropertiesResponseDocument.Factory.newInstance();
				res.addNewUpdateResourcePropertiesResponse();
				return res;
			}
			catch(Exception ime){
				throw BaseFault.createFault("Modifications are not valid.", ime, true);	
			}
			
		}
	}

	@Override
	public GetResourcePropertyResponseDocument GetResourceProperty(
			org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocument in)
	throws BaseFault, ResourceUnknownFault, ResourceUnavailableFault,
	InvalidResourcePropertyQNameFault {
		if(requestAimsAtParent())
		{
			//that's the parent!
			return getParent().GetResourceProperty(in);
		}
		else
		{
			return createResource().GetResourceProperty(in);
			
		}
	}

	@Override
	public GetMultipleResourcePropertiesResponseDocument GetMultipleResourceProperties(
			GetMultipleResourcePropertiesDocument in)
	throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault {
		if(requestAimsAtParent())
		{
			//that's the parent!
			return getParent().GetMultipleResourceProperties(in);
		}
		else
		{
			return createResource().GetMultipleResourceProperties(in);
			
		}
	}

	@Override
	public QueryResourcePropertiesResponseDocument QueryResourceProperties(
			QueryResourcePropertiesDocument in) throws ResourceUnknownFault,
			ResourceUnavailableFault, BaseFault {
		if(requestAimsAtParent())
		{
			//that's the parent!
			return getParent().QueryResourceProperties(in);
		}
		else
		{
			return createResource().QueryResourceProperties(in);
			
		}
	}

	@Override
	public SetResourcePropertiesResponseDocument SetResourceProperties(
			SetResourcePropertiesDocument in) throws ResourceUnknownFault,
			ResourceUnavailableFault, BaseFault {
		if(requestAimsAtParent())
		{
			//that's the parent!
			return getParent().SetResourceProperties(in);
		}
		else
		{
			throw BaseFault.createFault("Not implemented.");
			
		}
	}

	public RNSNodeWSRFHandler getHandler() {
		return handler;
	}

	public void setHandler(RNSNodeWSRFHandler handler) {
		this.handler = handler;
	}

	public RNSSupport getRnsSupport() {
		return rnsSupport;
	}

	public void setRnsSupport(RNSSupport rnsSupport) {
		this.rnsSupport = rnsSupport;
	}

	public WSResource getParent() {
		return parent;
	}

	public void setParent(WSResource parent) {
		this.parent = parent;
	}

	private RNSNode getRequestedNode() throws ResourceUnknownFault
	{
		try {
			return rnsSupport.getRequestedNode();	
		} catch (BaseFault e) {
			throw ResourceUnknownFault.createFault();
		}
	}
	
	private boolean requestAimsAtParent()
	{
		String path = getRnsSupport().getRequestedPath();
		return "/".equals(path);
	}
	
	private WSResource createResource() throws ResourceUnknownFault, InvalidResourcePropertyQNameFault, BaseFault, ResourceUnavailableFault
	{
		RNSNode child = getRequestedNode();
		QName docName = handler.getResourcePropertyDocumentQName();
		VirtualWSResource res = new VirtualWSResource(docName);
		for(QName name : handler.getResourcePropertyQNames())
		{
			res.setResourceProperty(name, handler.getResourceProperty(child, name));
		}
		return res;
	}
	
}
