package de.fzj.unicore.uas.impl.rns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;

import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.rns.RNSEntryDoesNotExistFault;
import de.fzj.unicore.uas.rns.RNSEntryExistsFault;
import de.fzj.unicore.uas.rns.WriteNotPermittedFault;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class SimpleRNSNode extends RNSNodeWithMetadata {

	private static final long serialVersionUID = 1L;
	private SortedMap<String,RNSNode> children = new ConcurrentSkipListMap<String, RNSNode>();
	
	public SimpleRNSNode(String name)
	{
		this(name, null);
	}

	public SimpleRNSNode(String name, EndpointReferenceType epr) {
		this(name, epr, new ArrayList<RNSNode>());
	}

	public SimpleRNSNode(String name, EndpointReferenceType epr, RNSNode... children) {
		this(name, epr, Arrays.asList(children));
	}

	public SimpleRNSNode(String name, EndpointReferenceType epr, Collection<RNSNode> kids) {
		super(name,epr,kids);
		
	}

	@Override
	public Collection<RNSNode> getChildren() throws BaseFault {
		return children.values();
	}

	@Override
	public RNSNode getChild(String name) throws BaseFault {
		RNSNode result = children.get(name);
		if(result == null) throw new RNSEntryDoesNotExistFault(name);
		return result;
	}

	@Override
	public void addChild(RNSNode child) throws BaseFault {
		RNSNode previous = children.put(child.getName(), child);
		if(previous != null)
		{
			children.put(previous.getName(), previous);
			throw new RNSEntryExistsFault(child.getName());
		}
	}

	

	@Override
	public RNSNode removeChild(String name) throws BaseFault,
			WriteNotPermittedFault {
		RNSNode result = children.remove(name);
		if(result == null) throw new RNSEntryDoesNotExistFault(name);
		return result;
	}

	@Override
	public RNSNode createDir(String name, boolean supportsRNS)
			throws BaseFault {
		EndpointReferenceType childEpr;
		try {
			childEpr = RNSUtils.getChildEPR(getEPR(), name);
		} catch (Exception e) {
			LogUtil.logException("Could not create child dir: "+e.getMessage(),e,logger);
			throw BaseFault.createFault("Could not create child dir: "+e.getMessage());
		} 
		SimpleRNSNode result = new SimpleRNSNode(name,childEpr);
		addChild(result);
		return result;
	}

	@Override
	public RNSNode createFile(String name)throws BaseFault {
		throw new WriteNotPermittedFault(name);
	}
}
